/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope;

import com.kircherelectronics.fsensor.BaseFilter;
import com.kircherelectronics.fsensor.util.angle.AngleUtils;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationGyroscope
extends BaseFilter {
    private static final String TAG = OrientationGyroscope.class.getSimpleName();
    private static final float NS2S = 1.0E-9f;
    private static final float EPSILON = 1.0E-9f;
    private Quaternion rotationVectorGyroscope;
    private float[] output = new float[3];
    private long timestamp = 0L;

    @Override
    public float[] getOutput() {
        return this.output;
    }

    public float[] calculateOrientation(float[] gyroscope, long timestamp) {
        if (this.isBaseOrientationSet()) {
            if (this.timestamp != 0L) {
                float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, dT, 1.0E-9f);
                this.output = AngleUtils.getAngles(this.rotationVectorGyroscope.getQ0(), this.rotationVectorGyroscope.getQ1(), this.rotationVectorGyroscope.getQ2(), this.rotationVectorGyroscope.getQ3());
            }
            this.timestamp = timestamp;
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }

    public void setBaseOrientation(Quaternion baseOrientation) {
        this.rotationVectorGyroscope = baseOrientation;
    }

    public void reset() {
        this.rotationVectorGyroscope = null;
        this.timestamp = 0L;
    }

    public boolean isBaseOrientationSet() {
        return this.rotationVectorGyroscope != null;
    }
}

