/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.util.rotation;

import android.hardware.SensorManager;
import java.util.Arrays;
import org.apache.commons.math3.complex.Quaternion;

public class RotationUtil {
    public static Quaternion integrateGyroscopeRotation(Quaternion previousRotationVector, float[] rateOfRotation, float dt, float epsilon) {
        float magnitude = (float)Math.sqrt(Math.pow(rateOfRotation[0], 2.0) + Math.pow(rateOfRotation[1], 2.0) + Math.pow(rateOfRotation[2], 2.0));
        if (magnitude > epsilon) {
            rateOfRotation[0] = rateOfRotation[0] / magnitude;
            rateOfRotation[1] = rateOfRotation[1] / magnitude;
            rateOfRotation[2] = rateOfRotation[2] / magnitude;
        }
        float thetaOverTwo = magnitude * dt / 2.0f;
        float sinThetaOverTwo = (float)Math.sin(thetaOverTwo);
        float cosThetaOverTwo = (float)Math.cos(thetaOverTwo);
        double[] deltaVector = new double[]{sinThetaOverTwo * rateOfRotation[0], sinThetaOverTwo * rateOfRotation[1], sinThetaOverTwo * rateOfRotation[2], cosThetaOverTwo};
        return previousRotationVector.multiply(new Quaternion(deltaVector[3], Arrays.copyOfRange(deltaVector, 0, 3)));
    }

    public static float[] getOrientationVectorFromAccelerationMagnetic(float[] acceleration, float[] magnetic) {
        float[] rotationMatrix = new float[9];
        if (SensorManager.getRotationMatrix((float[])rotationMatrix, null, (float[])acceleration, (float[])magnetic)) {
            float[] baseOrientation = new float[3];
            SensorManager.getOrientation((float[])rotationMatrix, (float[])baseOrientation);
            return baseOrientation;
        }
        return null;
    }

    public static Quaternion getOrientationQuaternionFromAccelerationMagnetic(float[] acceleration, float[] magnetic) {
        return RotationUtil.vectorToQuaternion(RotationUtil.getOrientationVectorFromAccelerationMagnetic(acceleration, magnetic));
    }

    public static Quaternion vectorToQuaternion(float[] vector) {
        if (vector != null) {
            double c1 = Math.cos(vector[0] / 2.0f);
            double s1 = Math.sin(vector[0] / 2.0f);
            double c2 = Math.cos(vector[1] / 2.0f);
            double s2 = Math.sin(vector[1] / 2.0f);
            double c3 = Math.cos(vector[2] / 2.0f);
            double s3 = Math.sin(vector[2] / 2.0f);
            double c1c2 = c1 * c2;
            double s1s2 = s1 * s2;
            double w = c1c2 * c3 - s1s2 * s3;
            double x = c1c2 * s3 + s1s2 * c3;
            double y = s1 * c2 * c3 + c1 * s2 * s3;
            double z = c1 * s2 * c3 - s1 * c2 * s3;
            return new Quaternion(w, -z, -x, -y);
        }
        return null;
    }
}

