/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman;

import android.hardware.SensorManager;
import android.util.Log;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.OrientationFused;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.complimentary.OrientationFusedComplimentary;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationKalmanFilter;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationMeasurementModel;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationProcessModel;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import java.util.Arrays;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationFusedKalman
extends OrientationFused {
    private static final String tag = OrientationFusedComplimentary.class.getSimpleName();
    private RotationKalmanFilter kalmanFilter;
    private RotationProcessModel pm;
    private RotationMeasurementModel mm;
    private volatile boolean run;
    private volatile float dT;
    private volatile float[] output = new float[3];
    private Thread thread;
    private volatile Quaternion rotationOrientation;

    public OrientationFusedKalman() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFusedKalman(float timeConstant) {
        super(timeConstant);
        this.pm = new RotationProcessModel();
        this.mm = new RotationMeasurementModel();
        this.kalmanFilter = new RotationKalmanFilter(this.pm, this.mm);
    }

    public void startFusion() {
        if (!this.run && this.thread == null) {
            this.run = true;
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (OrientationFusedKalman.this.run && !Thread.interrupted()) {
                        OrientationFusedKalman.this.calculate();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            Log.e((String)tag, (String)"Kalman Thread Run", (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                    }
                    Thread.currentThread().interrupt();
                }
            });
            this.thread.start();
        }
    }

    public void stopFusion() {
        if (this.run && this.thread != null) {
            this.run = false;
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    private float[] calculate() {
        if (this.rotationVectorGyroscope != null && this.rotationOrientation != null && this.dT != 0.0f) {
            double[] vectorGyroscope = new double[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            double[] vectorAccelerationMagnetic = new double[]{(float)this.rotationOrientation.getVectorPart()[0], (float)this.rotationOrientation.getVectorPart()[1], (float)this.rotationOrientation.getVectorPart()[2], (float)this.rotationOrientation.getScalarPart()};
            this.kalmanFilter.predict(vectorGyroscope);
            this.kalmanFilter.correct(vectorAccelerationMagnetic);
            this.rotationVectorGyroscope = new Quaternion(this.kalmanFilter.getStateEstimation()[3], Arrays.copyOfRange(this.kalmanFilter.getStateEstimation(), 0, 3));
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            SensorManager.getOrientation((float[])fusedMatrix, (float[])this.output);
            return this.output;
        }
        return null;
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.rotationVectorGyroscope != null) {
            if (this.timestamp != 0L) {
                this.dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                this.rotationOrientation = RotationUtil.getOrientationQuaternionFromAccelerationMagnetic(acceleration, magnetic);
                this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, this.dT, 1.0E-9f);
            }
            this.timestamp = timestamp;
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] orientation) {
        if (this.rotationVectorGyroscope != null) {
            if (this.timestamp != 0L) {
                this.dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                this.rotationOrientation = RotationUtil.vectorToQuaternion(orientation);
                this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, this.dT, 1.0E-9f);
            }
            this.timestamp = timestamp;
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }
}

