/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope.fusion.complimentary;

import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.OrientationFused;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationFusedComplimentary
extends OrientationFused {
    private static final String tag = OrientationFusedComplimentary.class.getSimpleName();

    public OrientationFusedComplimentary() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFusedComplimentary(float timeConstant) {
        super(timeConstant);
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.rotationVectorGyroscope != null) {
            if (this.timestamp != 0L) {
                float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                float alpha = this.timeConstant / (this.timeConstant + dT);
                float oneMinusAlpha = 1.0f - alpha;
                Quaternion rotationVectorAccelerationMagnetic = RotationUtil.getOrientationQuaternionFromAccelerationMagnetic(acceleration, magnetic);
                this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, dT, 1.0E-9f);
                Quaternion scaledRotationVectorAccelerationMagnetic = rotationVectorAccelerationMagnetic.multiply((double)oneMinusAlpha);
                Quaternion scaledRotationVectorGyroscope = this.rotationVectorGyroscope.multiply((double)alpha);
                this.rotationVectorGyroscope = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
            }
            this.timestamp = timestamp;
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            SensorManager.getOrientation((float[])fusedMatrix, (float[])this.output);
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] orientationVector) {
        if (this.rotationVectorGyroscope != null) {
            if (this.timestamp != 0L) {
                float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                float alpha = this.timeConstant / (this.timeConstant + dT);
                float oneMinusAlpha = 1.0f - alpha;
                Quaternion rotationVectorAccelerationMagnetic = RotationUtil.vectorToQuaternion(orientationVector);
                this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, dT, 1.0E-9f);
                Quaternion scaledRotationVectorAccelerationMagnetic = rotationVectorAccelerationMagnetic.multiply((double)oneMinusAlpha);
                Quaternion scaledRotationVectorGyroscope = this.rotationVectorGyroscope.multiply((double)alpha);
                this.rotationVectorGyroscope = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
            }
            this.timestamp = timestamp;
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            SensorManager.getOrientation((float[])fusedMatrix, (float[])this.output);
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }
}

