/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.averaging;

import com.kircherelectronics.fsensor.filter.averaging.AveragingFilter;

public class LowPassFilter
extends AveragingFilter {
    private static final String tag = LowPassFilter.class.getSimpleName();
    private float[] output;

    public LowPassFilter() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public LowPassFilter(float timeConstant) {
        this.timeConstant = timeConstant;
        this.reset();
    }

    public float[] filter(float[] values) {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        this.timestamp = System.nanoTime();
        float dt = 1.0f / ((float)this.count++ / ((float)(this.timestamp - this.startTime) / 1.0E9f));
        float alpha = this.timeConstant / (this.timeConstant + dt);
        this.output[0] = alpha * this.output[0] + (1.0f - alpha) * values[0];
        this.output[1] = alpha * this.output[1] + (1.0f - alpha) * values[1];
        this.output[2] = alpha * this.output[2] + (1.0f - alpha) * values[2];
        return this.output;
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    public void setTimeConstant(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    @Override
    public void reset() {
        super.reset();
        this.output = new float[]{0.0f, 0.0f, 0.0f};
    }
}

