/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.acceleration;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.OrientationFusedKalman;
import com.kircherelectronics.fsensor.linearacceleration.LinearAcceleration;
import com.kircherelectronics.fsensor.linearacceleration.LinearAccelerationFusion;
import com.kircherelectronics.fsensor.sensor.FSensor;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import io.reactivex.subjects.PublishSubject;

public class KalmanLinearAccelerationSensor
implements FSensor {
    private static final String TAG = KalmanLinearAccelerationSensor.class.getSimpleName();
    private SensorManager sensorManager;
    private SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private boolean hasRotation = false;
    private boolean hasMagnetic = false;
    private float[] magnetic = new float[3];
    private float[] rawAcceleration = new float[3];
    private float[] rotation = new float[3];
    private float[] acceleration = new float[3];
    private float[] output = new float[4];
    private LinearAcceleration linearAccelerationFilterKalman;
    private OrientationFusedKalman orientationFusionKalman;
    private int sensorFrequency = 0;
    private PublishSubject<float[]> publishSubject;

    public KalmanLinearAccelerationSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.publishSubject = PublishSubject.create();
        this.initializeFSensorFusions();
    }

    @Override
    public PublishSubject<float[]> getPublishSubject() {
        return this.publishSubject;
    }

    public void onStart() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorFrequency);
        this.orientationFusionKalman.startFusion();
    }

    public void onStop() {
        this.orientationFusionKalman.stopFusion();
        this.unregisterSensors();
    }

    public void setSensorFrequency(int sensorFrequency) {
        this.sensorFrequency = sensorFrequency;
    }

    public void reset() {
        this.onStop();
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rotation = new float[3];
        this.output = new float[4];
        this.hasRotation = false;
        this.hasMagnetic = false;
        this.onStart();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void initializeFSensorFusions() {
        this.orientationFusionKalman = new OrientationFusedKalman();
        this.linearAccelerationFilterKalman = new LinearAccelerationFusion(this.orientationFusionKalman);
    }

    private void processRawAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.rawAcceleration, 0, this.rawAcceleration.length);
    }

    private void processAcceleration(float[] acceleration) {
        System.arraycopy(acceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void processMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void processRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void registerSensors(int sensorDelay) {
        this.orientationFusionKalman.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(16), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.publishSubject.onNext((Object)this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private SimpleSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                KalmanLinearAccelerationSensor.this.processRawAcceleration(event.values);
                if (!KalmanLinearAccelerationSensor.this.orientationFusionKalman.isBaseOrientationSet()) {
                    if (KalmanLinearAccelerationSensor.this.hasRotation && KalmanLinearAccelerationSensor.this.hasMagnetic) {
                        KalmanLinearAccelerationSensor.this.orientationFusionKalman.setBaseOrientation(RotationUtil.getOrientationVectorFromAccelerationMagnetic(KalmanLinearAccelerationSensor.this.rawAcceleration, KalmanLinearAccelerationSensor.this.magnetic));
                    }
                } else {
                    KalmanLinearAccelerationSensor.this.orientationFusionKalman.calculateFusedOrientation(KalmanLinearAccelerationSensor.this.rotation, event.timestamp, KalmanLinearAccelerationSensor.this.rawAcceleration, KalmanLinearAccelerationSensor.this.magnetic);
                    KalmanLinearAccelerationSensor.this.processAcceleration(KalmanLinearAccelerationSensor.this.linearAccelerationFilterKalman.filter(KalmanLinearAccelerationSensor.this.rawAcceleration));
                    KalmanLinearAccelerationSensor.this.setOutput(KalmanLinearAccelerationSensor.this.acceleration);
                }
            } else if (event.sensor.getType() == 2) {
                KalmanLinearAccelerationSensor.this.processMagnetic(event.values);
                KalmanLinearAccelerationSensor.this.hasMagnetic = true;
            } else if (event.sensor.getType() == 16) {
                KalmanLinearAccelerationSensor.this.processRotation(event.values);
                KalmanLinearAccelerationSensor.this.hasRotation = true;
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

