/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.util.rotation;

import android.hardware.SensorManager;
import java.util.Arrays;
import org.apache.commons.math3.complex.Quaternion;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;

public class RotationUtil {
    public static Quaternion integrateGyroscopeRotation(Quaternion previousRotationVector, float[] rateOfRotation, float dt, float epsilon) {
        float magnitude = (float)Math.sqrt(Math.pow(rateOfRotation[0], 2.0) + Math.pow(rateOfRotation[1], 2.0) + Math.pow(rateOfRotation[2], 2.0));
        if (magnitude > epsilon) {
            rateOfRotation[0] = rateOfRotation[0] / magnitude;
            rateOfRotation[1] = rateOfRotation[1] / magnitude;
            rateOfRotation[2] = rateOfRotation[2] / magnitude;
        }
        float thetaOverTwo = magnitude * dt / 2.0f;
        float sinThetaOverTwo = (float)Math.sin(thetaOverTwo);
        float cosThetaOverTwo = (float)Math.cos(thetaOverTwo);
        double[] deltaVector = new double[]{sinThetaOverTwo * rateOfRotation[0], sinThetaOverTwo * rateOfRotation[1], sinThetaOverTwo * rateOfRotation[2], cosThetaOverTwo};
        return previousRotationVector.multiply(new Quaternion(deltaVector[3], Arrays.copyOfRange(deltaVector, 0, 3)));
    }

    public static Quaternion getOrientationVectorFromAccelerationMagnetic(float[] acceleration, float[] magnetic) {
        float[] rotationMatrix = new float[9];
        if (SensorManager.getRotationMatrix((float[])rotationMatrix, null, (float[])acceleration, (float[])magnetic)) {
            float[] rv = new float[3];
            SensorManager.getOrientation((float[])rotationMatrix, (float[])rv);
            Rotation rotation = new Rotation(RotationOrder.XYZ, RotationConvention.VECTOR_OPERATOR, (double)rv[1], (double)(-rv[2]), (double)rv[0]);
            return new Quaternion(rotation.getQ0(), rotation.getQ1(), rotation.getQ2(), rotation.getQ3());
        }
        return null;
    }

    private static double[][] convertTo2DArray(float[] rotation) {
        if (rotation.length != 9) {
            throw new IllegalStateException("Length must be of 9! Length: " + rotation.length);
        }
        double[][] rm = new double[3][3];
        rm[0][0] = rotation[0];
        rm[0][1] = rotation[1];
        rm[0][2] = rotation[2];
        rm[1][0] = rotation[3];
        rm[1][1] = rotation[4];
        rm[1][2] = rotation[5];
        rm[2][0] = rotation[6];
        rm[2][1] = rotation[7];
        rm[2][2] = rotation[8];
        return rm;
    }
}

