/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.gyroscope;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.OrientationFusedKalman;
import com.kircherelectronics.fsensor.sensor.FSensor;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import io.reactivex.subjects.PublishSubject;

public class KalmanGyroscopeSensor
implements FSensor {
    private static final String TAG = KalmanGyroscopeSensor.class.getSimpleName();
    private SensorManager sensorManager;
    private SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private boolean hasAcceleration = false;
    private boolean hasMagnetic = false;
    private float[] magnetic = new float[3];
    private float[] acceleration = new float[3];
    private float[] rotation = new float[3];
    private float[] output = new float[4];
    private OrientationFusedKalman orientationFusionKalman;
    private int sensorFrequency = 0;
    private PublishSubject<float[]> publishSubject;

    public KalmanGyroscopeSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.publishSubject = PublishSubject.create();
        this.initializeFSensorFusions();
    }

    @Override
    public PublishSubject<float[]> getPublishSubject() {
        return this.publishSubject;
    }

    public void onStart() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorFrequency);
        this.orientationFusionKalman.startFusion();
    }

    public void onStop() {
        this.orientationFusionKalman.stopFusion();
        this.unregisterSensors();
    }

    public void setSensorFrequency(int sensorFrequency) {
        this.sensorFrequency = sensorFrequency;
    }

    public void reset() {
        this.onStop();
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rotation = new float[3];
        this.output = new float[4];
        this.hasAcceleration = false;
        this.hasMagnetic = false;
        this.onStart();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void initializeFSensorFusions() {
        this.orientationFusionKalman = new OrientationFusedKalman();
    }

    private void processAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void processMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void processRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void registerSensors(int sensorDelay) {
        this.orientationFusionKalman.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(16), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.publishSubject.onNext((Object)this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private SimpleSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                KalmanGyroscopeSensor.this.processAcceleration(event.values);
                KalmanGyroscopeSensor.this.hasAcceleration = true;
            } else if (event.sensor.getType() == 2) {
                KalmanGyroscopeSensor.this.processMagnetic(event.values);
                KalmanGyroscopeSensor.this.hasMagnetic = true;
            } else if (event.sensor.getType() == 16) {
                KalmanGyroscopeSensor.this.processRotation(event.values);
                if (!KalmanGyroscopeSensor.this.orientationFusionKalman.isBaseOrientationSet()) {
                    if (KalmanGyroscopeSensor.this.hasAcceleration && KalmanGyroscopeSensor.this.hasMagnetic) {
                        KalmanGyroscopeSensor.this.orientationFusionKalman.setBaseOrientation(RotationUtil.getOrientationVectorFromAccelerationMagnetic(KalmanGyroscopeSensor.this.acceleration, KalmanGyroscopeSensor.this.magnetic));
                    }
                } else {
                    KalmanGyroscopeSensor.this.setOutput(KalmanGyroscopeSensor.this.orientationFusionKalman.calculateFusedOrientation(KalmanGyroscopeSensor.this.rotation, event.timestamp, KalmanGyroscopeSensor.this.acceleration, KalmanGyroscopeSensor.this.magnetic));
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

