/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.acceleration;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.complementary.OrientationFusedComplementary;
import com.kircherelectronics.fsensor.linearacceleration.LinearAcceleration;
import com.kircherelectronics.fsensor.linearacceleration.LinearAccelerationFusion;
import com.kircherelectronics.fsensor.sensor.FSensor;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import io.reactivex.subjects.PublishSubject;

public class ComplementaryLinearAccelerationSensor
implements FSensor {
    private static final String TAG = ComplementaryLinearAccelerationSensor.class.getSimpleName();
    private SensorManager sensorManager;
    private SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private boolean hasRotation = false;
    private boolean hasMagnetic = false;
    private float[] magnetic = new float[3];
    private float[] rawAcceleration = new float[3];
    private float[] rotation = new float[3];
    private float[] acceleration = new float[3];
    private float[] output = new float[4];
    private LinearAcceleration linearAccelerationFilterComplimentary;
    private OrientationFusedComplementary orientationFusionComplimentary;
    private int sensorFrequency = 0;
    private PublishSubject<float[]> publishSubject;

    public ComplementaryLinearAccelerationSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.publishSubject = PublishSubject.create();
        this.initializeFSensorFusions();
    }

    @Override
    public PublishSubject<float[]> getPublishSubject() {
        return this.publishSubject;
    }

    public void onStart() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorFrequency);
    }

    public void onStop() {
        this.unregisterSensors();
    }

    public void setSensorFrequency(int sensorFrequency) {
        this.sensorFrequency = sensorFrequency;
    }

    public void setFSensorComplimentaryLinearAccelerationTimeConstant(float timeConstant) {
        this.orientationFusionComplimentary.setTimeConstant(timeConstant);
    }

    public void reset() {
        this.onStop();
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rotation = new float[3];
        this.output = new float[4];
        this.hasRotation = false;
        this.hasMagnetic = false;
        this.onStart();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void initializeFSensorFusions() {
        this.orientationFusionComplimentary = new OrientationFusedComplementary();
        this.linearAccelerationFilterComplimentary = new LinearAccelerationFusion(this.orientationFusionComplimentary);
    }

    private void processRawAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.rawAcceleration, 0, this.rawAcceleration.length);
    }

    private void processAcceleration(float[] acceleration) {
        System.arraycopy(acceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void processMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void processRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void registerSensors(int sensorDelay) {
        this.orientationFusionComplimentary.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(16), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.publishSubject.onNext((Object)this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private SimpleSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                ComplementaryLinearAccelerationSensor.this.processRawAcceleration(event.values);
                if (!ComplementaryLinearAccelerationSensor.this.orientationFusionComplimentary.isBaseOrientationSet()) {
                    if (ComplementaryLinearAccelerationSensor.this.hasRotation && ComplementaryLinearAccelerationSensor.this.hasMagnetic) {
                        ComplementaryLinearAccelerationSensor.this.orientationFusionComplimentary.setBaseOrientation(RotationUtil.getOrientationVectorFromAccelerationMagnetic(ComplementaryLinearAccelerationSensor.this.rawAcceleration, ComplementaryLinearAccelerationSensor.this.magnetic));
                    }
                } else {
                    ComplementaryLinearAccelerationSensor.this.orientationFusionComplimentary.calculateFusedOrientation(ComplementaryLinearAccelerationSensor.this.rotation, event.timestamp, ComplementaryLinearAccelerationSensor.this.rawAcceleration, ComplementaryLinearAccelerationSensor.this.magnetic);
                    ComplementaryLinearAccelerationSensor.this.processAcceleration(ComplementaryLinearAccelerationSensor.this.linearAccelerationFilterComplimentary.filter(ComplementaryLinearAccelerationSensor.this.rawAcceleration));
                    ComplementaryLinearAccelerationSensor.this.setOutput(ComplementaryLinearAccelerationSensor.this.acceleration);
                }
            } else if (event.sensor.getType() == 2) {
                ComplementaryLinearAccelerationSensor.this.processMagnetic(event.values);
                ComplementaryLinearAccelerationSensor.this.hasMagnetic = true;
            } else if (event.sensor.getType() == 16) {
                ComplementaryLinearAccelerationSensor.this.processRotation(event.values);
                ComplementaryLinearAccelerationSensor.this.hasRotation = true;
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

