/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman;

import android.util.Log;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.OrientationFused;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.complementary.OrientationFusedComplementary;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationKalmanFilter;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationMeasurementModel;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.filter.RotationProcessModel;
import com.kircherelectronics.fsensor.util.angle.AngleUtils;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import java.util.Arrays;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationFusedKalman
extends OrientationFused {
    private static final String TAG = OrientationFusedComplementary.class.getSimpleName();
    private RotationKalmanFilter kalmanFilter;
    private volatile boolean run;
    private volatile float dT;
    private volatile float[] output = new float[3];
    private Thread thread;
    private volatile Quaternion rotationOrientation;

    public OrientationFusedKalman() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFusedKalman(float timeConstant) {
        super(timeConstant);
        this.kalmanFilter = new RotationKalmanFilter(new RotationProcessModel(), new RotationMeasurementModel());
    }

    public void startFusion() {
        if (!this.run && this.thread == null) {
            this.run = true;
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (OrientationFusedKalman.this.run && !Thread.interrupted()) {
                        OrientationFusedKalman.this.calculate();
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException e) {
                            Log.e((String)TAG, (String)"Kalman Thread Run", (Throwable)e);
                            Thread.currentThread().interrupt();
                        }
                    }
                    Thread.currentThread().interrupt();
                }
            });
            this.thread.start();
        }
    }

    public void stopFusion() {
        if (this.run && this.thread != null) {
            this.run = false;
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    private float[] calculate() {
        if (this.rotationVectorGyroscope != null && this.rotationOrientation != null && this.dT != 0.0f) {
            double[] vectorGyroscope = new double[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            double[] vectorAccelerationMagnetic = new double[]{(float)this.rotationOrientation.getVectorPart()[0], (float)this.rotationOrientation.getVectorPart()[1], (float)this.rotationOrientation.getVectorPart()[2], (float)this.rotationOrientation.getScalarPart()};
            this.kalmanFilter.predict(vectorGyroscope);
            this.kalmanFilter.correct(vectorAccelerationMagnetic);
            this.rotationVectorGyroscope = new Quaternion(this.kalmanFilter.getStateEstimation()[3], Arrays.copyOfRange(this.kalmanFilter.getStateEstimation(), 0, 3));
            this.output = AngleUtils.getAngles(this.rotationVectorGyroscope.getQ0(), this.rotationVectorGyroscope.getQ1(), this.rotationVectorGyroscope.getQ2(), this.rotationVectorGyroscope.getQ3());
            return this.output;
        }
        return null;
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.isBaseOrientationSet()) {
            if (this.timestamp != 0L) {
                this.dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                this.rotationOrientation = RotationUtil.getOrientationVectorFromAccelerationMagnetic(acceleration, magnetic);
                this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, this.dT, 1.0E-9f);
            }
            this.timestamp = timestamp;
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }
}

