/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.averaging;

import com.kircherelectronics.fsensor.filter.averaging.AveragingFilter;
import java.util.ArrayDeque;
import java.util.Arrays;

public class MeanFilter
extends AveragingFilter {
    private static final String tag = MeanFilter.class.getSimpleName();
    private ArrayDeque<float[]> values = new ArrayDeque();
    private float[] output;

    public MeanFilter() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public MeanFilter(float timeConstant) {
        super(timeConstant);
    }

    @Override
    public float[] filter(float[] data) {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        this.timestamp = System.nanoTime();
        float hz = (float)this.count++ / ((float)(this.timestamp - this.startTime) / 1.0E9f);
        int filterWindow = (int)Math.ceil(hz * this.timeConstant);
        this.values.addLast(Arrays.copyOf(data, data.length));
        while (this.values.size() > filterWindow) {
            this.values.removeFirst();
        }
        if (!this.values.isEmpty()) {
            this.output = this.getMean(this.values);
        } else {
            this.output = new float[data.length];
            System.arraycopy(data, 0, this.output, 0, data.length);
        }
        return this.output;
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    private float[] getMean(ArrayDeque<float[]> data) {
        float[] mean = new float[data.getFirst().length];
        for (float[] axis : data) {
            for (int i = 0; i < axis.length; ++i) {
                int n = i;
                mean[n] = mean[n] + axis[i];
            }
        }
        int i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / (float)data.size();
        }
        return mean;
    }

    public void setTimeConstant(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.values != null) {
            this.values.clear();
        }
    }
}

