/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.fusion;

import android.hardware.SensorManager;
import android.util.Log;
import com.kircherelectronics.fsensor.filter.fusion.OrientationFusion;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationComplimentaryFusion
extends OrientationFusion {
    private static final String tag = OrientationComplimentaryFusion.class.getSimpleName();
    private float[] output = new float[3];

    public OrientationComplimentaryFusion() {
        this(DEFAULT_TIME_CONSTANT);
        this.output = new float[3];
    }

    public OrientationComplimentaryFusion(float timeConstant) {
        super(timeConstant);
    }

    @Override
    protected float[] calculateFusedOrientation(float[] gyroscope, float dt, float[] acceleration, float[] magnetic) {
        float[] baseOrientation = this.getBaseOrientation(acceleration, magnetic);
        if (baseOrientation != null) {
            float alpha = this.timeConstant / (this.timeConstant + dt);
            float oneMinusAlpha = 1.0f - alpha;
            Quaternion rotationVectorAccelerationMagnetic = this.rotationVectorToQuaternion(baseOrientation);
            this.initializeRotationVectorGyroscopeIfRequired(rotationVectorAccelerationMagnetic);
            this.rotationVectorGyroscope = this.getGyroscopeRotationVector(this.rotationVectorGyroscope, gyroscope, dt);
            Quaternion scaledRotationVectorAccelerationMagnetic = rotationVectorAccelerationMagnetic.multiply((double)oneMinusAlpha);
            Quaternion scaledRotationVectorGyroscope = this.rotationVectorGyroscope.multiply((double)alpha);
            this.rotationVectorGyroscope = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            SensorManager.getOrientation((float[])fusedMatrix, (float[])this.output);
            return this.output;
        }
        Log.w((String)tag, (String)"Base Device Orientation could not be computed!");
        return null;
    }

    @Override
    protected float[] calculateFusedOrientation(float[] gyroscope, float dt, float[] orientation) {
        float[] baseOrientation = orientation;
        if (baseOrientation != null) {
            float alpha = this.timeConstant / (this.timeConstant + dt);
            float oneMinusAlpha = 1.0f - alpha;
            Quaternion baseOrientationQuaternion = this.rotationVectorToQuaternion(baseOrientation);
            this.initializeRotationVectorGyroscopeIfRequired(baseOrientationQuaternion);
            this.rotationVectorGyroscope = this.getGyroscopeRotationVector(this.rotationVectorGyroscope, gyroscope, dt);
            Quaternion scaledRotationVectorAccelerationMagnetic = baseOrientationQuaternion.multiply((double)oneMinusAlpha);
            Quaternion scaledRotationVectorGyroscope = this.rotationVectorGyroscope.multiply((double)alpha);
            this.rotationVectorGyroscope = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            SensorManager.getOrientation((float[])fusedMatrix, (float[])this.output);
            return this.output;
        }
        Log.w((String)tag, (String)"Base Device Orientation could not be computed!");
        return null;
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    @Override
    public void startFusion() {
    }

    @Override
    public void stopFusion() {
    }
}

