/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.rotation.raw;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.tracqi.fsensor.math.angle.Angles;
import com.tracqi.fsensor.rotation.Rotation;
import org.apache.commons.math3.complex.Quaternion;

public class GyroscopeRotation
implements Rotation {
    private static final float NS2S = 1.0E-9f;
    private static final float EPSILON = 1.0E-9f;
    private Quaternion rotationQuaternion = Quaternion.IDENTITY;
    private final float[] rotation = new float[3];
    private final SensorEventListener sensorEventListener = new SensorListener();
    private long timestamp = 0L;
    private final SensorManager sensorManager;

    public GyroscopeRotation(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
    }

    @Override
    public void start(int sensorDelay) {
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(4), sensorDelay);
    }

    @Override
    public void stop() {
        this.sensorManager.unregisterListener(this.sensorEventListener);
    }

    @Override
    public float[] getOrientation() {
        return this.rotation;
    }

    public void setBaseOrientation(Quaternion baseOrientation) {
        this.rotationQuaternion = baseOrientation;
    }

    private void calculateOrientation(float[] gyroscope, long timestamp) {
        if (this.timestamp != 0L) {
            float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
            this.rotationQuaternion = com.tracqi.fsensor.math.rotation.Rotation.integrateGyroscopeRotation(this.rotationQuaternion, gyroscope, dT, 1.0E-9f);
            float[] angles = Angles.getAngles(this.rotationQuaternion.getQ0(), this.rotationQuaternion.getQ1(), this.rotationQuaternion.getQ2(), this.rotationQuaternion.getQ3());
            this.rotation[0] = angles[0];
            this.rotation[1] = angles[1];
            this.rotation[2] = angles[2];
        }
        this.timestamp = timestamp;
    }

    private class SensorListener
    implements SensorEventListener {
        private SensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 4) {
                GyroscopeRotation.this.calculateOrientation(event.values, event.timestamp);
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

