/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.rotation.fusion.kalman;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.tracqi.fsensor.math.angle.Angles;
import com.tracqi.fsensor.math.gravity.Gravity;
import com.tracqi.fsensor.math.rotation.Rotation;
import com.tracqi.fsensor.rotation.fusion.FusedRotation;
import com.tracqi.fsensor.rotation.fusion.complementary.ComplimentaryRotation;
import com.tracqi.fsensor.rotation.fusion.kalman.filter.KalmanFilter;
import com.tracqi.fsensor.rotation.fusion.kalman.filter.RotationMeasurementModel;
import com.tracqi.fsensor.rotation.fusion.kalman.filter.RotationProcessModel;
import java.util.Arrays;
import org.apache.commons.math3.complex.Quaternion;
import org.apache.commons.math3.filter.MeasurementModel;
import org.apache.commons.math3.filter.ProcessModel;

public class KalmanRotation
extends FusedRotation {
    private static final String TAG = ComplimentaryRotation.class.getSimpleName();
    private final SensorManager sensorManager;
    private final SensorEventListener sensorEventListener = new SensorListener();
    private final KalmanFilter kalmanFilter;
    private volatile float dT;
    private final float[] magnetic = new float[3];
    private final float[] acceleration = new float[3];
    private final float[] rotation = new float[3];
    private final float[] output = new float[3];
    private long rotationTimestamp;
    private long timestamp;
    private volatile Quaternion rotationVectorAccelerationMagnetic;
    private final double[] vectorGyroscope = new double[4];
    private final double[] vectorAccelerationMagnetic = new double[4];

    public KalmanRotation(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
        this.kalmanFilter = new KalmanFilter(new RotationProcessModel(), new RotationMeasurementModel());
    }

    public KalmanRotation(SensorManager sensorManager, ProcessModel processModel, MeasurementModel measurementModel) {
        this.sensorManager = sensorManager;
        this.kalmanFilter = new KalmanFilter(processModel, measurementModel);
    }

    @Override
    public void start(int sensorDelay) {
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(4), sensorDelay);
    }

    @Override
    public void stop() {
        this.sensorManager.unregisterListener(this.sensorEventListener);
    }

    @Override
    public float[] getOrientation() {
        return this.output;
    }

    private void copyAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void copyMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void copyRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.isBaseOrientationSet()) {
            if (this.timestamp != 0L) {
                this.dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                float timeConstant = 0.075f;
                float alpha = timeConstant / (timeConstant + this.dT);
                float oneMinusAlpha = 1.0f - alpha;
                float[] orientation = Angles.getAngles(this.rotationVector.getQ0(), this.rotationVector.getQ1(), this.rotationVector.getQ2(), this.rotationVector.getQ3());
                float[] gravity = Gravity.getGravityFromOrientation(orientation);
                for (int i = 0; i < gravity.length; ++i) {
                    gravity[i] = alpha * gravity[i] + oneMinusAlpha * acceleration[i];
                }
                this.rotationVectorAccelerationMagnetic = Rotation.getOrientationVector(gravity, magnetic);
                if (this.rotationVectorAccelerationMagnetic != null) {
                    this.rotationVector = Rotation.integrateGyroscopeRotation(this.rotationVector, gyroscope, this.dT, 1.0E-9f);
                    this.vectorGyroscope[0] = (float)this.rotationVector.getVectorPart()[0];
                    this.vectorGyroscope[1] = (float)this.rotationVector.getVectorPart()[1];
                    this.vectorGyroscope[2] = (float)this.rotationVector.getVectorPart()[2];
                    this.vectorGyroscope[3] = (float)this.rotationVector.getScalarPart();
                    this.vectorAccelerationMagnetic[0] = (float)this.rotationVectorAccelerationMagnetic.getVectorPart()[0];
                    this.vectorAccelerationMagnetic[1] = (float)this.rotationVectorAccelerationMagnetic.getVectorPart()[1];
                    this.vectorAccelerationMagnetic[2] = (float)this.rotationVectorAccelerationMagnetic.getVectorPart()[2];
                    this.vectorAccelerationMagnetic[3] = (float)this.rotationVectorAccelerationMagnetic.getScalarPart();
                    this.kalmanFilter.predict(this.vectorGyroscope);
                    this.kalmanFilter.correct(this.vectorAccelerationMagnetic);
                    Quaternion result = new Quaternion(this.kalmanFilter.getStateEstimation()[3], Arrays.copyOfRange(this.kalmanFilter.getStateEstimation(), 0, 3));
                    float[] angles = Angles.getAngles(result.getQ0(), result.getQ1(), result.getQ2(), result.getQ3());
                    System.arraycopy(angles, 0, this.output, 0, angles.length);
                }
            }
        } else {
            throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
        }
        this.timestamp = timestamp;
    }

    private class SensorListener
    implements SensorEventListener {
        private boolean hasAcceleration = false;
        private boolean hasRotation = false;
        private boolean hasMagnetic = false;

        private SensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                KalmanRotation.this.copyAcceleration(event.values);
                this.hasAcceleration = true;
            } else if (event.sensor.getType() == 2) {
                KalmanRotation.this.copyMagnetic(event.values);
                this.hasMagnetic = true;
            } else if (event.sensor.getType() == 4) {
                KalmanRotation.this.copyRotation(event.values);
                KalmanRotation.this.rotationTimestamp = event.timestamp;
                this.hasRotation = true;
            }
            if (this.hasAcceleration && this.hasRotation && this.hasMagnetic) {
                this.hasAcceleration = false;
                this.hasRotation = false;
                this.hasMagnetic = false;
                if (!KalmanRotation.this.isBaseOrientationSet()) {
                    KalmanRotation.this.setBaseOrientation(Rotation.getOrientationVector(KalmanRotation.this.acceleration, KalmanRotation.this.magnetic));
                } else {
                    KalmanRotation.this.calculateFusedOrientation(KalmanRotation.this.rotation, KalmanRotation.this.rotationTimestamp, KalmanRotation.this.acceleration, KalmanRotation.this.magnetic);
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

