/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.rotation.fusion.complementary;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.tracqi.fsensor.math.angle.Angles;
import com.tracqi.fsensor.math.gravity.Gravity;
import com.tracqi.fsensor.math.rotation.Rotation;
import com.tracqi.fsensor.rotation.fusion.FusedRotation;
import org.apache.commons.math3.complex.Quaternion;

public class ComplimentaryRotation
extends FusedRotation {
    private static final String TAG = ComplimentaryRotation.class.getSimpleName();
    private static final float DEFAULT_TIME_CONSTANT = 0.18f;
    private final SensorManager sensorManager;
    private final SensorEventListener sensorEventListener = new SensorListener();
    private final float[] acceleration = new float[3];
    private final float[] magnetic = new float[3];
    private final float[] rotation = new float[3];
    private final float[] output = new float[3];
    private long rotationTimestamp;
    private long timestamp;
    public float timeConstant = 0.18f;

    public ComplimentaryRotation(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
    }

    public ComplimentaryRotation(SensorManager sensorManager, float timeConstant) {
        this.sensorManager = sensorManager;
        this.timeConstant = timeConstant;
    }

    @Override
    public void start(int sensorDelay) {
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener(this.sensorEventListener, this.sensorManager.getDefaultSensor(4), sensorDelay);
    }

    @Override
    public void stop() {
        this.sensorManager.unregisterListener(this.sensorEventListener);
    }

    @Override
    public float[] getOrientation() {
        return this.output;
    }

    private void copyAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void copyMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void copyRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.isBaseOrientationSet()) {
            if (this.timestamp != 0L) {
                float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                float alpha = this.timeConstant / (this.timeConstant + dT);
                float oneMinusAlpha = 1.0f - alpha;
                float[] orientation = Angles.getAngles(this.rotationVector.getQ0(), this.rotationVector.getQ1(), this.rotationVector.getQ2(), this.rotationVector.getQ3());
                float[] gravity = Gravity.getGravityFromOrientation(orientation);
                for (int i = 0; i < gravity.length; ++i) {
                    gravity[i] = alpha * gravity[i] + oneMinusAlpha * acceleration[i];
                }
                Quaternion rotationVectorAccelerationMagnetic = Rotation.getOrientationVector(gravity, magnetic);
                if (rotationVectorAccelerationMagnetic != null) {
                    this.rotationVector = Rotation.integrateGyroscopeRotation(this.rotationVector, gyroscope, dT, 1.0E-9f);
                    Quaternion scaledRotationVectorAccelerationMagnetic = rotationVectorAccelerationMagnetic.multiply((double)oneMinusAlpha);
                    Quaternion scaledRotationVectorGyroscope = this.rotationVector.multiply((double)alpha);
                    Quaternion result = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
                    float[] angles = Angles.getAngles(result.getQ0(), result.getQ1(), result.getQ2(), result.getQ3());
                    System.arraycopy(angles, 0, this.output, 0, angles.length);
                }
            }
        } else {
            throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
        }
        this.timestamp = timestamp;
    }

    private class SensorListener
    implements SensorEventListener {
        private boolean hasAcceleration = false;
        private boolean hasRotation = false;
        private boolean hasMagnetic = false;

        private SensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                ComplimentaryRotation.this.copyAcceleration(event.values);
                this.hasAcceleration = true;
            } else if (event.sensor.getType() == 2) {
                ComplimentaryRotation.this.copyMagnetic(event.values);
                this.hasMagnetic = true;
            } else if (event.sensor.getType() == 4) {
                ComplimentaryRotation.this.copyRotation(event.values);
                ComplimentaryRotation.this.rotationTimestamp = event.timestamp;
                this.hasRotation = true;
            }
            if (this.hasAcceleration && this.hasRotation && this.hasMagnetic) {
                this.hasAcceleration = false;
                this.hasRotation = false;
                this.hasMagnetic = false;
                if (!ComplimentaryRotation.this.isBaseOrientationSet()) {
                    ComplimentaryRotation.this.setBaseOrientation(Rotation.getOrientationVector(ComplimentaryRotation.this.acceleration, ComplimentaryRotation.this.magnetic));
                } else {
                    ComplimentaryRotation.this.calculateFusedOrientation(ComplimentaryRotation.this.rotation, ComplimentaryRotation.this.rotationTimestamp, ComplimentaryRotation.this.acceleration, ComplimentaryRotation.this.magnetic);
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

