/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.filter;

import com.tracqi.fsensor.filter.SensorFilter;

public class LowPassFilter
extends SensorFilter {
    private static final String tag = LowPassFilter.class.getSimpleName();

    public LowPassFilter() {
    }

    public LowPassFilter(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    @Override
    public float[] filter(float[] values) {
        if (this.startTime == 0L) {
            this.startTime = System.nanoTime();
        }
        float dt = 1.0f / ((float)this.count++ / ((float)(System.nanoTime() - this.startTime) / 1.0E9f));
        float alpha = this.timeConstant / (this.timeConstant + dt);
        float oneMinusAlpha = 1.0f - alpha;
        this.output[0] = alpha * this.output[0] + oneMinusAlpha * values[0];
        this.output[1] = alpha * this.output[1] + oneMinusAlpha * values[1];
        this.output[2] = alpha * this.output[2] + oneMinusAlpha * values[2];
        return this.output;
    }
}

