/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.sensor.acceleration;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.tracqi.fsensor.math.gravity.Gravity;
import com.tracqi.fsensor.rotation.Rotation;
import com.tracqi.fsensor.sensor.BaseFSensor;
import com.tracqi.fsensor.sensor.FSensorEvent;
import com.tracqi.fsensor.sensor.FSensorEventListener;
import com.tracqi.fsensor.sensor.acceleration.ComplementaryLinearAccelerationFSensor;

public abstract class LinearAccelerationFSensor
extends BaseFSensor {
    private static final String TAG = ComplementaryLinearAccelerationFSensor.class.getSimpleName();
    private final SensorEventListener sensorEventListener = new SensorListener();

    public LinearAccelerationFSensor(SensorManager sensorManager, Rotation rotation) {
        super(sensorManager, rotation);
    }

    @Override
    protected SensorEventListener getSensorEventListener() {
        return this.sensorEventListener;
    }

    private void calculateLinerAcceleration(float[] acceleration, float[] gravity) {
        this.output[0] = acceleration[0] - gravity[0];
        this.output[1] = acceleration[1] - gravity[1];
        this.output[2] = acceleration[2] - gravity[2];
    }

    private class SensorListener
    implements SensorEventListener {
        private SensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                LinearAccelerationFSensor.this.calculateLinerAcceleration(event.values, Gravity.getGravityFromOrientation(LinearAccelerationFSensor.this.rotation.getOrientation()));
                for (FSensorEventListener sensorEventListener : LinearAccelerationFSensor.this.fSensorEventListeners) {
                    sensorEventListener.onSensorChanged(new FSensorEvent(event.sensor, event.accuracy, event.timestamp, LinearAccelerationFSensor.this.output));
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

