/*
 * Decompiled with CFR 0.152.
 */
package com.tracqi.fsensor.sensor;

import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.tracqi.fsensor.rotation.Rotation;
import com.tracqi.fsensor.sensor.FSensor;
import com.tracqi.fsensor.sensor.FSensorEventListener;
import com.tracqi.fsensor.sensor.acceleration.ComplementaryLinearAccelerationFSensor;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseFSensor
implements FSensor {
    private static final String TAG = ComplementaryLinearAccelerationFSensor.class.getSimpleName();
    protected final SensorManager sensorManager;
    protected final List<FSensorEventListener> fSensorEventListeners = new ArrayList<FSensorEventListener>();
    protected final Rotation rotation;
    protected final float[] output = new float[3];

    public BaseFSensor(SensorManager sensorManager, Rotation rotation) {
        this.sensorManager = sensorManager;
        this.rotation = rotation;
    }

    @Override
    public void registerListener(FSensorEventListener sensorEventListener, int sensorDelay) {
        if (this.fSensorEventListeners.isEmpty()) {
            this.registerSensors(sensorDelay);
            this.rotation.start(sensorDelay);
        }
        this.fSensorEventListeners.add(sensorEventListener);
    }

    @Override
    public void unregisterListener(FSensorEventListener sensorEventListener) {
        this.fSensorEventListeners.remove(sensorEventListener);
        if (this.fSensorEventListeners.isEmpty()) {
            this.unregisterSensors();
            this.rotation.stop();
        }
    }

    private void registerSensors(int sensorDelay) {
        this.sensorManager.registerListener(this.getSensorEventListener(), this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener(this.getSensorEventListener(), this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener(this.getSensorEventListener(), this.sensorManager.getDefaultSensor(4), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener(this.getSensorEventListener());
    }

    protected abstract SensorEventListener getSensorEventListener();
}

