/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope.fusion;

import com.kircherelectronics.fsensor.BaseFilter;
import org.apache.commons.math3.complex.Quaternion;

public abstract class OrientationFused
extends BaseFilter {
    protected static final float EPSILON = 1.0E-9f;
    protected static final float NS2S = 1.0E-9f;
    private static final String tag = OrientationFused.class.getSimpleName();
    public static float DEFAULT_TIME_CONSTANT = 0.18f;
    public float timeConstant;
    protected Quaternion rotationVector;
    protected long timestamp = 0L;
    protected float[] output = new float[3];

    public OrientationFused() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFused(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    @Override
    public float[] getOutput() {
        return this.output;
    }

    public void reset() {
        this.timestamp = 0L;
        this.rotationVector = null;
    }

    public boolean isBaseOrientationSet() {
        return this.rotationVector != null;
    }

    public void setTimeConstant(float timeConstant) {
        this.timeConstant = timeConstant;
    }

    public abstract float[] calculateFusedOrientation(float[] var1, long var2, float[] var4, float[] var5);

    public void setBaseOrientation(Quaternion baseOrientation) {
        this.rotationVector = baseOrientation;
    }
}

