/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.acceleration;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.observer.SensorSubject;
import com.kircherelectronics.fsensor.sensor.FSensor;

public class LinearAccelerationSensor
implements FSensor {
    private static final String TAG = LinearAccelerationSensor.class.getSimpleName();
    private final SensorManager sensorManager;
    private final SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private float[] acceleration = new float[3];
    private float[] output = new float[4];
    private int sensorDelay = 0;
    private final SensorSubject sensorSubject;

    public LinearAccelerationSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.sensorSubject = new SensorSubject();
    }

    @Override
    public void start() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorDelay);
    }

    @Override
    public void stop() {
        this.unregisterSensors();
    }

    @Override
    public void register(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.register(sensorObserver);
    }

    @Override
    public void unregister(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.unregister(sensorObserver);
    }

    public void setSensorDelay(int sensorDelay) {
        if (sensorDelay != 0 && sensorDelay != 1 && sensorDelay != 3 && sensorDelay != 2) {
            throw new IllegalStateException("Sensor Frequency must be SensorManager.SENSOR_DELAY_FASTEST, SensorManager.SENSOR_DELAY_GAME, SensorManager.SENSOR_DELAY_NORMAL or SensorManager.SENSOR_DELAY_UI");
        }
        this.sensorDelay = sensorDelay;
    }

    @Override
    public void reset() {
        this.stop();
        this.acceleration = new float[3];
        this.output = new float[4];
        this.start();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void processAcceleration(float[] acceleration) {
        System.arraycopy(acceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void registerSensors(int sensorDelay) {
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(10), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.sensorSubject.onNext(this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private SimpleSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 10) {
                LinearAccelerationSensor.this.processAcceleration(event.values);
                LinearAccelerationSensor.this.setOutput(LinearAccelerationSensor.this.acceleration);
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

