/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.util.angle;

import android.util.Log;

public class AngleUtils {
    private static final String TAG = AngleUtils.class.getSimpleName();

    public static float[] getAngles(double w, double z, double x, double y) {
        double test = x * y + z * w;
        if (test > 0.499) {
            double heading = 2.0 * Math.atan2(x, w);
            double pitch = -1.5707963267948966;
            double roll = 0.0;
            Log.e((String)TAG, (String)"singularity at north pole");
            return new float[]{(float)heading, (float)pitch, (float)roll};
        }
        if (test < -0.499) {
            double heading = -2.0 * Math.atan2(x, w);
            double pitch = 1.5707963267948966;
            double roll = 0.0;
            Log.e((String)TAG, (String)"singularity at south pole");
            return new float[]{(float)heading, (float)pitch, (float)roll};
        }
        double sqx = x * x;
        double sqy = y * y;
        double sqz = z * z;
        double heading = -Math.atan2(2.0 * y * w - 2.0 * x * z, 1.0 - 2.0 * sqy - 2.0 * sqz);
        double pitch = -Math.asin(2.0 * test);
        double roll = -Math.atan2(2.0 * x * w - 2.0 * y * z, 1.0 - 2.0 * sqx - 2.0 * sqz);
        return new float[]{(float)heading, (float)pitch, (float)roll};
    }
}

