/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.gyroscope;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.kalman.OrientationFusedKalman;
import com.kircherelectronics.fsensor.observer.SensorSubject;
import com.kircherelectronics.fsensor.sensor.FSensor;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;

public class KalmanGyroscopeSensor
implements FSensor {
    private static final String TAG = KalmanGyroscopeSensor.class.getSimpleName();
    private final SensorManager sensorManager;
    private final SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private float[] magnetic = new float[3];
    private float[] acceleration = new float[3];
    private float[] rotation = new float[3];
    private float[] output = new float[4];
    private OrientationFusedKalman orientationFusionKalman;
    private int sensorDelay = 0;
    private int sensorType = 4;
    private final SensorSubject sensorSubject;

    public KalmanGyroscopeSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.sensorSubject = new SensorSubject();
        this.initializeFSensorFusions();
    }

    @Override
    public void start() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorDelay);
        this.orientationFusionKalman.startFusion();
    }

    @Override
    public void stop() {
        this.orientationFusionKalman.stopFusion();
        this.unregisterSensors();
    }

    @Override
    public void register(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.register(sensorObserver);
    }

    @Override
    public void unregister(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.unregister(sensorObserver);
    }

    public void setSensorType(int sensorType) {
        if (sensorType != 4 && sensorType != 16) {
            throw new IllegalStateException("Sensor Type must be Sensor.TYPE_GYROSCOPE or Sensor.TYPE_GYROSCOPE_UNCALIBRATED");
        }
        this.sensorType = sensorType;
    }

    public void setSensorDelay(int sensorDelay) {
        if (sensorDelay != 0 && sensorDelay != 1 && sensorDelay != 3 && sensorDelay != 2) {
            throw new IllegalStateException("Sensor Frequency must be SensorManager.SENSOR_DELAY_FASTEST, SensorManager.SENSOR_DELAY_GAME, SensorManager.SENSOR_DELAY_NORMAL or SensorManager.SENSOR_DELAY_UI");
        }
        this.sensorDelay = sensorDelay;
    }

    public void reset() {
        this.stop();
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rotation = new float[3];
        this.output = new float[4];
        this.listener.reset();
        this.start();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void initializeFSensorFusions() {
        this.orientationFusionKalman = new OrientationFusedKalman();
    }

    private void processAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void processMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void processRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void registerSensors(int sensorDelay) {
        this.orientationFusionKalman.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(this.sensorType), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.sensorSubject.onNext(this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private boolean hasAcceleration = false;
        private boolean hasMagnetic = false;

        private SimpleSensorListener() {
        }

        private void reset() {
            this.hasAcceleration = false;
            this.hasMagnetic = false;
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                KalmanGyroscopeSensor.this.processAcceleration(event.values);
                this.hasAcceleration = true;
            } else if (event.sensor.getType() == 2) {
                KalmanGyroscopeSensor.this.processMagnetic(event.values);
                this.hasMagnetic = true;
            } else if (event.sensor.getType() == KalmanGyroscopeSensor.this.sensorType) {
                KalmanGyroscopeSensor.this.processRotation(event.values);
                if (!KalmanGyroscopeSensor.this.orientationFusionKalman.isBaseOrientationSet()) {
                    if (this.hasAcceleration && this.hasMagnetic) {
                        KalmanGyroscopeSensor.this.orientationFusionKalman.setBaseOrientation(RotationUtil.getOrientationVectorFromAccelerationMagnetic(KalmanGyroscopeSensor.this.acceleration, KalmanGyroscopeSensor.this.magnetic));
                    }
                } else {
                    KalmanGyroscopeSensor.this.setOutput(KalmanGyroscopeSensor.this.orientationFusionKalman.calculateFusedOrientation(KalmanGyroscopeSensor.this.rotation, event.timestamp, KalmanGyroscopeSensor.this.acceleration, KalmanGyroscopeSensor.this.magnetic));
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

