/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.gyroscope;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.OrientationGyroscope;
import com.kircherelectronics.fsensor.sensor.FSensor;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import io.reactivex.subjects.PublishSubject;

public class GyroscopeSensor
implements FSensor {
    private static final String TAG = GyroscopeSensor.class.getSimpleName();
    private SensorManager sensorManager;
    private SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private boolean hasAcceleration = false;
    private boolean hasMagnetic = false;
    private float[] magnetic = new float[3];
    private float[] acceleration = new float[3];
    private float[] rotation = new float[3];
    private float[] output = new float[4];
    private OrientationGyroscope orientationGyroscope;
    private int sensorFrequency = 0;
    private PublishSubject<float[]> publishSubject;

    public GyroscopeSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.publishSubject = PublishSubject.create();
        this.initializeFSensorFusions();
    }

    @Override
    public PublishSubject<float[]> getPublishSubject() {
        return this.publishSubject;
    }

    public void onStart() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorFrequency);
    }

    public void onStop() {
        this.unregisterSensors();
    }

    public void setSensorFrequency(int sensorFrequency) {
        this.sensorFrequency = sensorFrequency;
    }

    public void reset() {
        this.onStop();
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rotation = new float[3];
        this.output = new float[4];
        this.hasAcceleration = false;
        this.hasMagnetic = false;
        this.onStart();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void initializeFSensorFusions() {
        this.orientationGyroscope = new OrientationGyroscope();
    }

    private void processAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void processMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void processRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void registerSensors(int sensorDelay) {
        this.orientationGyroscope.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(4), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.publishSubject.onNext((Object)this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private int sensorEventThreshold = 500;
        private int numAccelerationEvents = 0;
        private int numMagneticEvents = 0;

        private SimpleSensorListener() {
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                GyroscopeSensor.this.processAcceleration(event.values);
                if (this.numAccelerationEvents++ > this.sensorEventThreshold) {
                    GyroscopeSensor.this.hasAcceleration = true;
                }
            } else if (event.sensor.getType() == 2) {
                GyroscopeSensor.this.processMagnetic(event.values);
                if (this.numMagneticEvents++ > this.sensorEventThreshold) {
                    GyroscopeSensor.this.hasMagnetic = true;
                }
            } else if (event.sensor.getType() == 4) {
                GyroscopeSensor.this.processRotation(event.values);
                if (!GyroscopeSensor.this.orientationGyroscope.isBaseOrientationSet()) {
                    if (GyroscopeSensor.this.hasAcceleration && GyroscopeSensor.this.hasMagnetic) {
                        GyroscopeSensor.this.orientationGyroscope.setBaseOrientation(RotationUtil.getOrientationVectorFromAccelerationMagnetic(GyroscopeSensor.this.acceleration, GyroscopeSensor.this.magnetic));
                    }
                } else {
                    GyroscopeSensor.this.setOutput(GyroscopeSensor.this.orientationGyroscope.calculateOrientation(GyroscopeSensor.this.rotation, event.timestamp));
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

