/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.gyroscope.fusion.complimentary;

import android.util.Log;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.OrientationFused;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;
import org.apache.commons.math3.complex.Quaternion;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.RotationConvention;
import org.apache.commons.math3.geometry.euclidean.threed.RotationOrder;

public class OrientationFusedComplimentary
extends OrientationFused {
    private static final String TAG = OrientationFusedComplimentary.class.getSimpleName();

    public OrientationFusedComplimentary() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationFusedComplimentary(float timeConstant) {
        super(timeConstant);
    }

    @Override
    public float[] calculateFusedOrientation(float[] gyroscope, long timestamp, float[] acceleration, float[] magnetic) {
        if (this.isBaseOrientationSet()) {
            if (this.timestamp != 0L) {
                float dT = (float)(timestamp - this.timestamp) * 1.0E-9f;
                float alpha = this.timeConstant / (this.timeConstant + dT);
                float oneMinusAlpha = 1.0f - alpha;
                Quaternion rotationVectorAccelerationMagnetic = RotationUtil.getOrientationVectorFromAccelerationMagnetic(acceleration, magnetic);
                if (rotationVectorAccelerationMagnetic != null) {
                    this.rotationVectorGyroscope = RotationUtil.integrateGyroscopeRotation(this.rotationVectorGyroscope, gyroscope, dT, 1.0E-9f);
                    Quaternion scaledRotationVectorAccelerationMagnetic = rotationVectorAccelerationMagnetic.multiply((double)oneMinusAlpha);
                    Quaternion scaledRotationVectorGyroscope = this.rotationVectorGyroscope.multiply((double)alpha);
                    this.rotationVectorGyroscope = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
                }
                Rotation rotation = new Rotation(this.rotationVectorGyroscope.getQ0(), this.rotationVectorGyroscope.getQ1(), this.rotationVectorGyroscope.getQ2(), this.rotationVectorGyroscope.getQ3(), true);
                try {
                    this.output = OrientationFusedComplimentary.doubleToFloat(rotation.getAngles(RotationOrder.XYZ, RotationConvention.VECTOR_OPERATOR));
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)"", (Throwable)e);
                }
            }
            this.timestamp = timestamp;
            return this.output;
        }
        throw new IllegalStateException("You must call setBaseOrientation() before calling calculateFusedOrientation()!");
    }

    private static float[] doubleToFloat(double[] values) {
        float[] f = new float[values.length];
        for (int i = 0; i < f.length; ++i) {
            f[i] = (float)values[i];
        }
        return f;
    }
}

