/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.filter.fusion;

import android.hardware.SensorManager;
import android.util.Log;
import com.kircherelectronics.fsensor.filter.fusion.OrientationFusion;
import org.apache.commons.math3.complex.Quaternion;

public class OrientationComplimentaryFusion
extends OrientationFusion {
    private static final String tag = OrientationComplimentaryFusion.class.getSimpleName();

    public OrientationComplimentaryFusion() {
        this(DEFAULT_TIME_CONSTANT);
    }

    public OrientationComplimentaryFusion(float timeConstant) {
        super(timeConstant);
    }

    @Override
    protected float[] calculateFusedOrientation(float[] gyroscope, float dt, float[] acceleration, float[] magnetic) {
        float[] baseOrientation = this.getBaseOrientation(acceleration, magnetic);
        if (baseOrientation != null) {
            float alpha = this.timeConstant / (this.timeConstant + dt);
            float oneMinusAlpha = 1.0f - alpha;
            Quaternion rotationVectorAccelerationMagnetic = this.getAccelerationMagneticRotationVector(baseOrientation);
            this.initializeRotationVectorGyroscopeIfRequired(rotationVectorAccelerationMagnetic);
            this.rotationVectorGyroscope = this.getGyroscopeRotationVector(this.rotationVectorGyroscope, gyroscope, dt);
            Quaternion scaledRotationVectorAccelerationMagnetic = rotationVectorAccelerationMagnetic.multiply((double)oneMinusAlpha);
            Quaternion scaledRotationVectorGyroscope = this.rotationVectorGyroscope.multiply((double)alpha);
            this.rotationVectorGyroscope = scaledRotationVectorGyroscope.add(scaledRotationVectorAccelerationMagnetic);
            float[] fusedVector = new float[]{(float)this.rotationVectorGyroscope.getVectorPart()[0], (float)this.rotationVectorGyroscope.getVectorPart()[1], (float)this.rotationVectorGyroscope.getVectorPart()[2], (float)this.rotationVectorGyroscope.getScalarPart()};
            float[] fusedMatrix = new float[9];
            SensorManager.getRotationMatrixFromVector((float[])fusedMatrix, (float[])fusedVector);
            float[] fusedOrientation = new float[3];
            SensorManager.getOrientation((float[])fusedMatrix, (float[])fusedOrientation);
            return fusedOrientation;
        }
        Log.w((String)tag, (String)"Base Device Orientation could not be computed!");
        return null;
    }

    @Override
    public void startFusion() {
    }

    @Override
    public void stopFusion() {
    }
}

