/*
 * Decompiled with CFR 0.152.
 */
package com.queue.library;

import android.os.Handler;
import android.os.SystemClock;

public final class BlockingRunnable
implements Runnable {
    private final Runnable mTask;
    private boolean mDone;

    public BlockingRunnable(Runnable task) {
        this.mTask = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mTask.run();
        }
        finally {
            BlockingRunnable blockingRunnable = this;
            synchronized (blockingRunnable) {
                this.mDone = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postAndWait(Handler handler, long timeout) {
        if (!handler.post((Runnable)this)) {
            return false;
        }
        BlockingRunnable blockingRunnable = this;
        synchronized (blockingRunnable) {
            if (timeout > 0L) {
                long expirationTime = SystemClock.uptimeMillis() + timeout;
                while (!this.mDone) {
                    long delay = expirationTime - SystemClock.uptimeMillis();
                    if (delay <= 0L) {
                        return false;
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                while (!this.mDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return true;
    }
}

