/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.util.SparseArray;
import com.download.library.AsyncTask;
import com.download.library.DownloadNotifier;
import com.download.library.DownloadTask;
import com.download.library.ExecuteTask;
import com.download.library.IDownloader;
import com.download.library.Runtime;
import com.download.library.StorageEngine;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Downloader
extends AsyncTask
implements IDownloader<DownloadTask>,
ExecuteTask {
    protected volatile DownloadTask mDownloadTask;
    private volatile long mLoaded = 0L;
    protected volatile long mTotals = -1L;
    private long mLastLoaded = 0L;
    private long mUsedTime = 0L;
    private long mLastTime = 0L;
    private volatile long mBeginTime = 0L;
    private volatile long mAverageSpeed = 0L;
    protected volatile Throwable mThrowable;
    protected long mDownloadTimeOut = Long.MAX_VALUE;
    protected long mConnectTimeOut = 10000L;
    private static final String TAG = "Download-" + Downloader.class.getSimpleName();
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_REDIRECTS = 7;
    private static final int HTTP_TEMP_REDIRECT = 307;
    public static final int ERROR_NETWORK_CONNECTION = 16384;
    public static final int ERROR_RESPONSE_STATUS = 16385;
    public static final int ERROR_STORAGE = 16386;
    public static final int ERROR_TIME_OUT = 16387;
    public static final int ERROR_USER_PAUSE = 16388;
    public static final int ERROR_USER_CANCEL = 16390;
    public static final int ERROR_SHUTDOWN = 16391;
    public static final int ERROR_TOO_MANY_REDIRECTS = 16392;
    public static final int ERROR_LOAD = 16393;
    public static final int ERROR_RESOURCE_NOT_FOUND = 16400;
    public static final int ERROR_MD5 = 16401;
    public static final int ERROR_SERVICE = 20483;
    public static final int SUCCESSFUL = 8192;
    public static final int HTTP_RANGE_NOT_SATISFIABLE = 4016;
    protected static final SparseArray<String> DOWNLOAD_MESSAGE = new SparseArray(13);
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    protected volatile boolean enableProgress = false;
    protected boolean mCallbackInMainThread = false;
    protected boolean quickProgress = false;
    private StringBuffer mDownloadMessage = new StringBuffer();

    protected Downloader() {
    }

    static ExecuteTask create(DownloadTask downloadTask) {
        Downloader downloader = new Downloader();
        downloader.mDownloadTask = downloadTask;
        downloader.mTotals = downloadTask.getTotalsLength();
        downloader.mDownloadTimeOut = downloadTask.getDownloadTimeOut();
        downloader.mConnectTimeOut = downloadTask.getConnectTimeOut();
        downloader.quickProgress = downloadTask.isQuickProgress();
        downloader.enableProgress = downloadTask.isEnableIndicator() || null != downloadTask.getDownloadingListener();
        return downloader;
    }

    void checkIsNullTask(DownloadTask downloadTask) {
        if (null == downloadTask) {
            throw new NullPointerException("downloadTask can't be null.");
        }
        if (null == downloadTask.getContext()) {
            throw new NullPointerException("context can't be null.");
        }
    }

    private boolean checkSpace() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (downloadTask.getTotalsLength() - downloadTask.getFile().length() > Downloader.getFsAvailableSize(downloadTask.getFile().getParent()) - 0x6400000L) {
            Runtime.getInstance().logError(TAG, " \u7a7a\u95f4\u4e0d\u8db3");
            return false;
        }
        return true;
    }

    public static long getFsAvailableSize(String anyPathInFs) {
        if (TextUtils.isEmpty((CharSequence)anyPathInFs)) {
            return 0L;
        }
        try {
            long availableSize;
            long blockSize;
            StatFs statFs = new StatFs(anyPathInFs);
            if (Build.VERSION.SDK_INT >= 18) {
                blockSize = statFs.getBlockSizeLong();
                availableSize = statFs.getAvailableBlocksLong();
            } else {
                blockSize = statFs.getBlockSize();
                availableSize = statFs.getAvailableBlocks();
            }
            return blockSize * availableSize;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0L;
        }
    }

    private boolean checkNet() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (!downloadTask.isForceDownload()) {
            return Runtime.getInstance().checkWifi(downloadTask.getContext());
        }
        return Runtime.getInstance().checkNetwork(downloadTask.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground() {
        int error = 16393;
        DownloadTask downloadTask = this.mDownloadTask;
        if (downloadTask.isPausing()) {
            downloadTask.pause();
            return 16388;
        }
        if (downloadTask.isPaused()) {
            return 16388;
        }
        if (downloadTask.isCanceled()) {
            return 16390;
        }
        if (downloadTask.isDataURI()) {
            error = this.transferDataFromUrl();
            return error;
        }
        this.mBeginTime = SystemClock.elapsedRealtime();
        if (!this.checkNet()) {
            Runtime.getInstance().logError(TAG, " Network error,isForceDownload:" + this.mDownloadTask.isForceDownload());
            downloadTask.error();
            return 16384;
        }
        this.mDownloadMessage.append("\r\n").append("=============").append("\n");
        this.mDownloadMessage.append("Download Message").append("\n");
        this.mDownloadMessage.append("downloadTask id=").append(downloadTask.getId()).append("\n");
        this.mDownloadMessage.append("url=").append(downloadTask.getUrl()).append("\n");
        try {
            this.mDownloadMessage.append("file=").append(downloadTask.getFile() == null ? "" : downloadTask.getFile().getCanonicalPath()).append("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName("pool-download-thread-" + Runtime.getInstance().generateGlobalThreadId());
        try {
            downloadTask.setStatus(1002);
            IOException ioException = null;
            for (int i = 0; i <= downloadTask.retry; ++i) {
                block21: {
                    try {
                        error = this.doDownload();
                    }
                    catch (IOException e) {
                        ioException = e;
                        this.mThrowable = ioException;
                        error = 16393;
                        if (!Runtime.getInstance().isDebug()) break block21;
                        e.printStackTrace();
                    }
                }
                if (ioException == null) break;
                if (i == downloadTask.retry) {
                    downloadTask.error();
                    this.mDownloadTask.setThrowable(ioException);
                }
                this.mDownloadMessage.append("download error message: ").append(ioException.getMessage()).append("\n");
                if (i + 1 > downloadTask.retry) continue;
                this.mDownloadMessage.append("download error , retry ").append(i + 1).append("\n");
            }
            try {
                this.mDownloadMessage.append("final output file=").append(downloadTask.getFile() == null ? "" : downloadTask.getFile().getCanonicalPath()).append("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (downloadTask.getHeaders() != null && !downloadTask.getHeaders().isEmpty()) {
                this.mDownloadMessage.append("custom request headers=").append(downloadTask.getHeaders().toString()).append("\n");
            }
            this.mDownloadMessage.append("error=").append("0x" + Integer.toHexString(error)).append("\n");
            this.mDownloadMessage.append("error table: ERROR_NETWORK_CONNECTION = 0x4000,ERROR_RESPONSE_STATUS = 0x4001,ERROR_STORAGE = 0x4002,ERROR_TIME_OUT = 0x4003,ERROR_USER_PAUSE = 0x4004,ERROR_USER_CANCEL = 0x4006,ERROR_SHUTDOWN = 0x4007,ERROR_TOO_MANY_REDIRECTS = 0x4008,ERROR_LOAD = 0x4009,ERROR_RESOURCE_NOT_FOUND = 0x4010,ERROR_MD5 = 0x4011,ERROR_SERVICE = 0x5003,SUCCESSFUL = 0x2000,HTTP_RANGE_NOT_SATISFIABLE = 4016").append("\n");
            this.mDownloadMessage.append("error message=").append((String)DOWNLOAD_MESSAGE.get(error)).append("\n");
            this.mDownloadMessage.append("mLoaded=").append(this.mLoaded).append("\n");
            this.mDownloadMessage.append("mLastLoaded=").append(this.mLastLoaded).append("\n");
            this.mDownloadMessage.append("mLoaded+mLastLoaded=").append(this.mLoaded + this.mLastLoaded).append("\n");
            this.mDownloadMessage.append("totals=").append(this.mTotals).append("\n");
            if (downloadTask.getStatus() == 1005 || error == 16401) {
                this.mDownloadMessage.append("isCalculateMD5=").append(downloadTask.isCalculateMD5()).append("\n");
                if (!TextUtils.isEmpty((CharSequence)downloadTask.fileMD5)) {
                    this.mDownloadMessage.append("FileMD5=").append(downloadTask.fileMD5).append("\n");
                } else {
                    this.mDownloadMessage.append("FileMD5=").append("''").append("\n");
                }
            }
            if (!TextUtils.isEmpty((CharSequence)downloadTask.getTargetCompareMD5())) {
                this.mDownloadMessage.append("targetCompareMD5=").append(downloadTask.getTargetCompareMD5()).append("\n");
            }
            this.mDownloadMessage.append("current downloadTask status=").append(downloadTask.getStatus()).append("\n");
            this.mDownloadMessage.append("status table: STATUS_NEW = 1000,STATUS_PENDDING = 1001,STATUS_DOWNLOADING = 1002,STATUS_PAUSING = 1003,STATUS_PAUSED = 1004,STATUS_SUCCESSFUL = 1005,STATUS_CANCELED = 1006,STATUS_ERROR = 1007").append("\n");
            this.mDownloadMessage.append("used time=").append(downloadTask.getUsedTime()).append("ms").append("\n");
            this.mDownloadMessage.append("\r\n");
            Runtime.getInstance().log(TAG, "\r\n" + this.mDownloadMessage.toString());
        }
        finally {
            Thread.currentThread().setName(name);
        }
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferDataFromUrl() {
        DownloadTask downloadTask = this.mDownloadTask;
        String url = downloadTask.getUrl();
        if (!url.startsWith("data")) {
            return 16393;
        }
        if (!url.contains(",")) {
            return 16393;
        }
        String base64EncodedString = this.extractContent();
        if (TextUtils.isEmpty((CharSequence)base64EncodedString)) {
            return 16393;
        }
        byte[] decodedBytes = Base64.decode((String)base64EncodedString, (int)0);
        downloadTask.setContentLength(decodedBytes.length);
        downloadTask.setTotalsLength(decodedBytes.length);
        LoadingRandomAccessFile out = null;
        try {
            out = new LoadingRandomAccessFile(downloadTask.getFile());
            out.seek(0L);
            out.write(decodedBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.progressFinaly();
            this.closeIO(out);
        }
        return 8192;
    }

    String extractContent() {
        String chartset;
        DownloadTask downloadTask = this.mDownloadTask;
        if (!downloadTask.isDataURI()) {
            return "";
        }
        String url = downloadTask.mUrl;
        int end = url.indexOf(",", 5);
        if (end <= 5) {
            return "";
        }
        int start = -1;
        for (int i = end; i >= 5; --i) {
            String alpha = String.valueOf(url.charAt(i));
            if (!alpha.equals(";") && !alpha.equals(":")) continue;
            start = i + 1;
            break;
        }
        if (!(chartset = url.substring(start, end)).equalsIgnoreCase("base64")) {
            Runtime.getInstance().log(TAG, "unsupport chartset:" + chartset);
            return "";
        }
        String base64EncodedString = url.substring(url.indexOf(",", 5) + 1);
        return base64EncodedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload() throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        downloadTask.updateTime(this.mBeginTime);
        downloadTask.resetConnectTimes();
        int redirectionCount = 0;
        URL url = TextUtils.isEmpty((CharSequence)downloadTask.redirect) ? new URL(downloadTask.getUrl()) : new URL(downloadTask.getRedirect());
        HttpURLConnection httpURLConnection = null;
        try {
            block37: while (redirectionCount++ <= 7) {
                int e;
                this.mDownloadMessage.append("redirectionCount=").append(redirectionCount).append("\n");
                if (null != httpURLConnection) {
                    httpURLConnection.disconnect();
                }
                if (downloadTask.connectTimes <= 0) {
                    httpURLConnection = this.createUrlConnection(url);
                    this.settingHeaders(downloadTask, httpURLConnection);
                    httpURLConnection.connect();
                }
                httpURLConnection = this.createUrlConnection(url);
                this.settingHeaders(downloadTask, httpURLConnection);
                this.rangeHeaders(downloadTask, httpURLConnection);
                httpURLConnection.connect();
                if (downloadTask.isPausing()) {
                    downloadTask.pause();
                    e = 16388;
                    return e;
                }
                if (downloadTask.isPaused()) {
                    e = 16388;
                    return e;
                }
                if (downloadTask.isCanceled()) {
                    e = 16390;
                    return e;
                }
                boolean isEncodingChunked = false;
                try {
                    isEncodingChunked = "chunked".equalsIgnoreCase(httpURLConnection.getHeaderField("Transfer-Encoding"));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                long contentLength = -1L;
                contentLength = this.getHeaderFieldLong(httpURLConnection, "Content-Length");
                boolean hasLength = contentLength > 0L;
                boolean finishKnown = isEncodingChunked && hasLength || !isEncodingChunked && !hasLength;
                int responseCode = httpURLConnection.getResponseCode();
                Runtime.getInstance().log(TAG, "responseCode:" + responseCode);
                this.mDownloadMessage.append("responseCode=").append(responseCode).append("\n");
                if (responseCode == 206 && !hasLength) {
                    downloadTask.successful();
                    int n = 8192;
                    return n;
                }
                switch (responseCode) {
                    case 200: {
                        int n;
                        int compareResult;
                        if (finishKnown) {
                            Runtime.getInstance().logError(TAG, " error , giving up ,  EncodingChunked:" + isEncodingChunked + "  hasLength:" + hasLength + " response length:" + contentLength + " responseCode:" + responseCode);
                            downloadTask.error();
                            int n2 = 16393;
                            return n2;
                        }
                        this.mTotals = contentLength;
                        if (downloadTask.connectTimes <= 0) {
                            this.start(httpURLConnection);
                            ++downloadTask.connectTimes;
                            if (downloadTask.getFile().length() > 0L && !isEncodingChunked) {
                                if (downloadTask.getFile().length() == contentLength) {
                                    this.mDownloadMessage.append("file already exist, file name=").append(downloadTask.getFile().getName()).append(", file length==contentLength").append(",contentLength=").append(contentLength).append("\n");
                                    String fileMD5 = Runtime.getInstance().md5(downloadTask.getFile());
                                    compareResult = Runtime.getInstance().getFileComparator().compare(downloadTask.getUrl(), downloadTask.getFile(), downloadTask.getTargetCompareMD5(), fileMD5);
                                    this.mDownloadMessage.append("compareResult=").append(compareResult).append("\n");
                                    this.mDownloadMessage.append("compare Result table:").append("COMPARE_RESULT_SUCCESSFUL = 1").append(",COMPARE_RESULT_REDOWNLOAD_COVER = 2").append(",COMPARE_RESULT_REDOWNLOAD_RENAME = 3").append("\n");
                                    if (compareResult == 1) {
                                        downloadTask.setFileMD5(fileMD5);
                                        this.mLastLoaded = contentLength;
                                        this.publishProgressUpdate(1);
                                        downloadTask.successful();
                                        n = 8192;
                                        return n;
                                    }
                                    if (compareResult == 2) {
                                        downloadTask.getFile().delete();
                                        downloadTask.getFile().createNewFile();
                                        continue block37;
                                    }
                                    for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                                        String fileName = "(" + i + ")" + downloadTask.getFile().getName();
                                        File targetFile = new File(downloadTask.getFile().getParent(), fileName);
                                        if (targetFile.exists()) {
                                            if (targetFile.length() < contentLength) {
                                                this.mDownloadMessage.append("origin file name=").append(downloadTask.getFile().getName()).append(" target file name=").append(targetFile.getName()).append(",current target file length=").append(targetFile.length()).append("\n");
                                                downloadTask.setFileSafe(targetFile);
                                                continue block37;
                                            }
                                        } else {
                                            this.mDownloadMessage.append("target file is not exist, create new target file ,file name=").append(targetFile.getName()).append("\n");
                                            targetFile.createNewFile();
                                            downloadTask.setFileSafe(targetFile);
                                            continue block37;
                                        }
                                        Runtime.getInstance().log(TAG, "rename download , targetFile exists:" + targetFile.getName());
                                    }
                                    continue block37;
                                }
                                if (downloadTask.getFile().length() < contentLength) continue block37;
                                this.mDownloadMessage.append("file length error .").append("\n");
                                downloadTask.getFile().delete();
                                downloadTask.getFile().createNewFile();
                                continue block37;
                            }
                        }
                        if (isEncodingChunked) {
                            this.mTotals = -1L;
                        } else if (downloadTask.getFile().length() >= contentLength) {
                            this.mTotals = contentLength;
                            downloadTask.successful();
                            int fileMD5 = 8192;
                            return fileMD5;
                        }
                        downloadTask.setTotalsLength(this.mTotals);
                        if (!isEncodingChunked && !this.checkSpace()) {
                            downloadTask.error();
                            int fileMD5 = 16386;
                            return fileMD5;
                        }
                        this.saveEtag(httpURLConnection);
                        downloadTask.setTotalsLength(this.mTotals);
                        this.mDownloadMessage.append("totals=").append(this.mTotals).append("\n");
                        int fileMD5 = this.transferData(this.getInputStream(httpURLConnection), new LoadingRandomAccessFile(downloadTask.getFile()), false);
                        return fileMD5;
                    }
                    case 206: {
                        if (finishKnown) {
                            Runtime.getInstance().logError(TAG, " error , giving up ,  EncodingChunked:" + isEncodingChunked + "  hasLength:" + hasLength + " response length:" + contentLength + " responseCode:" + responseCode);
                            downloadTask.error();
                            int fileMD5 = 16393;
                            return fileMD5;
                        }
                        if (this.mTotals <= 0L) {
                            this.mTotals = contentLength + downloadTask.getFile().length();
                        }
                        if (this.mTotals > 0L && contentLength + downloadTask.getFile().length() != this.mTotals) {
                            downloadTask.error();
                            Runtime.getInstance().logError(TAG, "length error, this.mTotals:" + this.mTotals + " contentLength:" + contentLength + " file length:" + downloadTask.getFile().length());
                            int fileMD5 = 16393;
                            return fileMD5;
                        }
                        downloadTask.setTotalsLength(this.mTotals);
                        if (!this.checkSpace()) {
                            downloadTask.error();
                            int fileMD5 = 16386;
                            return fileMD5;
                        }
                        Runtime.getInstance().log(TAG, "last:" + this.mLastLoaded + " totals:" + this.mTotals);
                        this.mDownloadMessage.append("last=").append(this.mLastLoaded).append(" totals=").append(this.mTotals).append("\n");
                        int fileMD5 = this.transferData(this.getInputStream(httpURLConnection), new LoadingRandomAccessFile(downloadTask.getFile()), true);
                        return fileMD5;
                    }
                    case 4016: {
                        if (null == downloadTask.getFile()) break;
                        Runtime.getInstance().log(TAG, "range not satisfiable .");
                        this.mDownloadMessage.append("range not satisfiable .").append("\n");
                        downloadTask.getFile().delete();
                        downloadTask.getFile().createNewFile();
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        int n;
                        int compareResult;
                        String location = httpURLConnection.getHeaderField("Location");
                        if (TextUtils.isEmpty((CharSequence)location)) {
                            downloadTask.error();
                            compareResult = 20483;
                            return compareResult;
                        }
                        this.mDownloadMessage.append("original url=").append(httpURLConnection.getURL().toString()).append("  ,redirect url=" + location).append("\n");
                        try {
                            url = new URL(url, location);
                        }
                        catch (MalformedURLException exception) {
                            downloadTask.error();
                            n = 20483;
                            if (null != httpURLConnection) {
                                httpURLConnection.disconnect();
                            }
                            return n;
                        }
                        downloadTask.setRedirect(url.toString());
                        continue block37;
                    }
                    case 404: {
                        int n = 16400;
                        return n;
                    }
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: {
                        downloadTask.error();
                        int n = 20483;
                        return n;
                    }
                    default: {
                        downloadTask.error();
                        int n = 16385;
                        return n;
                    }
                }
            }
            downloadTask.error();
            int n = 16392;
            return n;
        }
        finally {
            if (null != httpURLConnection) {
                httpURLConnection.disconnect();
            }
        }
    }

    private void rangeHeaders(DownloadTask downloadTask, HttpURLConnection httpURLConnection) {
        if (null != downloadTask.getFile() && downloadTask.getFile().length() > 0L) {
            this.mLastLoaded = downloadTask.getFile().length();
            httpURLConnection.setRequestProperty("Range", "bytes=" + this.mLastLoaded + "-");
        }
        this.mDownloadMessage.append("range=").append(this.mLastLoaded).append("\n");
        httpURLConnection.setRequestProperty("Connection", "close");
    }

    private final void start(HttpURLConnection httpURLConnection) throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        if (TextUtils.isEmpty((CharSequence)downloadTask.getContentDisposition())) {
            downloadTask.setContentDisposition(httpURLConnection.getHeaderField("Content-Disposition"));
            String fileName = Runtime.getInstance().getFileNameByContentDisposition(downloadTask.getContentDisposition());
            if (!TextUtils.isEmpty((CharSequence)fileName) && !downloadTask.getFile().getName().equals(fileName)) {
                File renameTarget = new File(downloadTask.getFile().getParent(), fileName);
                if (renameTarget.exists()) {
                    downloadTask.setFileSafe(renameTarget);
                    this.updateNotifierTitle();
                } else {
                    File originFile = downloadTask.getFile();
                    boolean success = downloadTask.getFile().renameTo(renameTarget);
                    if (success) {
                        downloadTask.setFileSafe(renameTarget);
                        this.updateNotifierTitle();
                        this.mDownloadMessage.append("origin=").append(originFile.getName()).append(" rename=").append(renameTarget.getName()).append("\n");
                        originFile.delete();
                    }
                }
            }
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getMimetype())) {
            downloadTask.setMimetype(httpURLConnection.getHeaderField("Content-Type"));
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getUserAgent())) {
            String ua = httpURLConnection.getHeaderField("User-Agent");
            if (ua == null) {
                ua = "";
            }
            downloadTask.setUserAgent(ua);
        }
        downloadTask.setContentLength(this.getHeaderFieldLong(httpURLConnection, "Content-Length"));
        this.onStart();
    }

    private void updateNotifierTitle() {
        DownloadTask downloadTask = this.mDownloadTask;
        DownloadNotifier downloadNotifier = downloadTask.mDownloadNotifier;
        if (null != downloadNotifier) {
            downloadNotifier.updateTitle(downloadTask);
        }
    }

    protected void onStart() throws IOException {
        final DownloadTask downloadTask = this.mDownloadTask;
        if (null != downloadTask && null != downloadTask.getDownloadListener()) {
            HANDLER.post(new Runnable(){

                @Override
                public void run() {
                    downloadTask.getDownloadListener().onStart(downloadTask.mUrl, downloadTask.mUserAgent, downloadTask.mContentDisposition, downloadTask.mMimetype, downloadTask.mTotalsLength, downloadTask);
                }
            });
        }
    }

    private InputStream getInputStream(HttpURLConnection httpURLConnection) throws IOException {
        if ("gzip".equalsIgnoreCase(httpURLConnection.getContentEncoding())) {
            return new GZIPInputStream(httpURLConnection.getInputStream());
        }
        if ("deflate".equalsIgnoreCase(httpURLConnection.getContentEncoding())) {
            return new InflaterInputStream(httpURLConnection.getInputStream(), new Inflater(true));
        }
        return httpURLConnection.getInputStream();
    }

    private long getHeaderFieldLong(HttpURLConnection httpURLConnection, String name) {
        String field = httpURLConnection.getHeaderField(name);
        try {
            return null == field ? -1L : Long.parseLong(field);
        }
        catch (NumberFormatException e) {
            if (Runtime.getInstance().isDebug()) {
                e.printStackTrace();
            }
            return -1L;
        }
    }

    private void saveEtag(HttpURLConnection httpURLConnection) {
        String etag = httpURLConnection.getHeaderField("ETag");
        if (TextUtils.isEmpty((CharSequence)etag)) {
            return;
        }
        String url = this.mDownloadTask.getUrl();
        String urlMD5 = Runtime.getInstance().md5(url);
        Runtime.getInstance().log(TAG, "save etag:" + etag);
        StorageEngine storageEngine = Runtime.getInstance().getStorageEngine(this.mDownloadTask.mContext);
        storageEngine.save(urlMD5, etag);
    }

    private String getEtag() {
        String url = this.mDownloadTask.getUrl();
        String urlMD5 = Runtime.getInstance().md5(url);
        String etag = Runtime.getInstance().getStorageEngine(this.mDownloadTask.mContext).get(urlMD5, "-1");
        if (!TextUtils.isEmpty((CharSequence)etag) && !"-1".equals(etag)) {
            return etag;
        }
        return null;
    }

    private HttpURLConnection createUrlConnection(URL url) throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout((int)this.mConnectTimeOut);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setReadTimeout((int)downloadTask.getBlockMaxTime());
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("Accept-Encoding", "deflate,gzip");
        return httpURLConnection;
    }

    private void settingHeaders(DownloadTask downloadTask, HttpURLConnection httpURLConnection) {
        Map<String, String> headers = null;
        headers = downloadTask.getHeaders();
        if (null != headers && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        String eTag = "";
        eTag = this.getEtag();
        if (!TextUtils.isEmpty((CharSequence)eTag)) {
            Runtime.getInstance().log(TAG, "Etag:" + eTag);
            httpURLConnection.setRequestProperty("If-Match", this.getEtag());
        }
    }

    @Override
    protected void onProgressUpdate(Integer ... values) {
        DownloadTask downloadTask = this.mDownloadTask;
        DownloadNotifier downloadNotifier = downloadTask.mDownloadNotifier;
        try {
            long currentTime = SystemClock.elapsedRealtime();
            this.mUsedTime = currentTime - this.mBeginTime;
            this.mAverageSpeed = this.mUsedTime == 0L ? 0L : this.mLoaded * 1000L / this.mUsedTime;
            if (values != null && values.length > 0 && values[0] == 1 && null != downloadNotifier) {
                if (this.mTotals > 0L) {
                    int mProgress = (int)((float)(this.mLastLoaded + this.mLoaded) / Float.valueOf(this.mTotals).floatValue() * 100.0f);
                    downloadNotifier.onDownloading(mProgress);
                } else {
                    downloadNotifier.onDownloaded(this.mLastLoaded + this.mLoaded);
                }
            }
            if (null != downloadTask.getDownloadListener()) {
                downloadTask.getDownloadingListener().onProgress(downloadTask.getUrl(), this.mLastLoaded + this.mLoaded, this.mTotals, downloadTask.getUsedTime());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferData(InputStream inputStream, RandomAccessFile randomAccessFile, boolean isSeek) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);
        RandomAccessFile out = randomAccessFile;
        DownloadTask downloadTask = this.mDownloadTask;
        this.mLoaded = 0L;
        try {
            int n;
            if (isSeek) {
                out.seek(out.length());
            } else {
                out.seek(0L);
                this.mLastLoaded = 0L;
            }
            int bytes = 0;
            while (!(downloadTask.isPausing() || downloadTask.isCanceled() || downloadTask.isPaused())) {
                n = -1;
                try {
                    n = bis.read(buffer, 0, 8192);
                }
                catch (IOException e) {
                    downloadTask.error();
                    throw e;
                }
                if (n == -1) break;
                out.write(buffer, 0, n);
                bytes += n;
                if (SystemClock.elapsedRealtime() - this.mBeginTime <= this.mDownloadTimeOut) continue;
                this.mDownloadTask.error();
                int n2 = 16387;
                return n2;
            }
            if (downloadTask.isPausing()) {
                downloadTask.pause();
                n = 16388;
                return n;
            }
            if (downloadTask.isPaused()) {
                n = 16388;
                return n;
            }
            if (downloadTask.isCanceled()) {
                n = 16390;
                return n;
            }
            if (downloadTask.isCalculateMD5()) {
                String md5 = Runtime.getInstance().md5(this.mDownloadTask.mFile);
                this.mDownloadTask.setFileMD5(md5);
            }
            if (!TextUtils.isEmpty((CharSequence)downloadTask.getTargetCompareMD5())) {
                if (TextUtils.isEmpty((CharSequence)downloadTask.fileMD5)) {
                    String md5 = Runtime.getInstance().md5(this.mDownloadTask.mFile);
                    this.mDownloadTask.setFileMD5(md5);
                }
                if (!downloadTask.getTargetCompareMD5().equalsIgnoreCase(downloadTask.getFileMD5())) {
                    downloadTask.error();
                    int n3 = 16401;
                    return n3;
                }
            }
            this.progressFinaly();
            downloadTask.successful();
            int n4 = 8192;
            return n4;
        }
        finally {
            this.closeIO(out);
            this.closeIO(bis);
            this.closeIO(inputStream);
        }
    }

    public void closeIO(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final DownloadTask cancel() {
        DownloadTask downloadTask = this.mDownloadTask;
        try {
            DownloadTask downloadTask2 = downloadTask;
            return downloadTask2;
        }
        finally {
            downloadTask.cancel();
        }
    }

    @Override
    public int status() {
        DownloadTask downloadTask = this.mDownloadTask;
        return downloadTask == null ? 1000 : downloadTask.getStatus();
    }

    @Override
    public boolean download(DownloadTask downloadTask) {
        return true;
    }

    private final DownloadTask pause() {
        DownloadTask downloadTask = this.mDownloadTask;
        try {
            DownloadTask downloadTask2 = downloadTask;
            return downloadTask2;
        }
        finally {
            downloadTask.pausing();
        }
    }

    @Override
    public DownloadTask cancelDownload() {
        return this.cancel();
    }

    @Override
    public DownloadTask pauseDownload() {
        return this.pause();
    }

    @Override
    public DownloadTask getDownloadTask() {
        return this.mDownloadTask;
    }

    private void progressFinaly() {
        long currentTime;
        this.mLastTime = currentTime = SystemClock.elapsedRealtime();
        this.publishProgressUpdate(1);
    }

    private void onProgress() {
        if (!this.enableProgress) {
            return;
        }
        if (this.quickProgress) {
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime - this.mLastTime < 1200L) {
                this.publishProgressUpdate(0);
            } else {
                this.mLastTime = currentTime;
                this.publishProgressUpdate(1);
            }
        } else {
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime - this.mLastTime < 1200L) {
                return;
            }
            this.mLastTime = currentTime;
            this.publishProgressUpdate(1);
        }
    }

    private void publishProgressUpdate(int i) {
        if (this.mCallbackInMainThread) {
            this.publishProgress(i);
        } else {
            this.onProgressUpdate(i);
        }
    }

    static {
        DOWNLOAD_MESSAGE.append(16384, (Object)"Network connection error . ");
        DOWNLOAD_MESSAGE.append(16385, (Object)"Response code non-200 or non-206 . ");
        DOWNLOAD_MESSAGE.append(16386, (Object)"Insufficient memory space . ");
        DOWNLOAD_MESSAGE.append(16391, (Object)"Shutdown . ");
        DOWNLOAD_MESSAGE.append(16387, (Object)"Download time is overtime . ");
        DOWNLOAD_MESSAGE.append(16390, (Object)"The user canceled the download . ");
        DOWNLOAD_MESSAGE.append(16400, (Object)"Resource not found . ");
        DOWNLOAD_MESSAGE.append(16388, (Object)"paused . ");
        DOWNLOAD_MESSAGE.append(16393, (Object)"IO Error . ");
        DOWNLOAD_MESSAGE.append(20483, (Object)"Service Unavailable . ");
        DOWNLOAD_MESSAGE.append(16392, (Object)"Too many redirects . ");
        DOWNLOAD_MESSAGE.append(16401, (Object)"Md5 check fails . ");
        DOWNLOAD_MESSAGE.append(8192, (Object)"Download successful . ");
    }

    private final class LoadingRandomAccessFile
    extends RandomAccessFile {
        public LoadingRandomAccessFile(File file) throws FileNotFoundException {
            super(file, "rw");
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            super.write(buffer, offset, count);
            Downloader.this.mLoaded += count;
            DownloadTask downloadTask = Downloader.this.mDownloadTask;
            if (null != downloadTask) {
                downloadTask.setLoaded(Downloader.this.mLastLoaded + Downloader.this.mLoaded);
            }
            Downloader.this.onProgress();
        }
    }
}

