/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.net.Uri;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.download.library.DownloadListener;
import com.download.library.DownloadListenerAdapter;
import com.download.library.DownloadNotifier;
import com.download.library.DownloadStatusListener;
import com.download.library.DownloadTask;
import com.download.library.DownloadingListener;
import com.download.library.Extra;
import com.download.library.Runtime;
import com.queue.library.GlobalQueue;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DownloadTask
extends Extra
implements Serializable,
Cloneable {
    static final String TAG = "Download-" + DownloadTask.class.getSimpleName();
    int mId = Runtime.getInstance().generateGlobalId();
    long mTotalsLength;
    protected Context mContext;
    protected File mFile;
    protected DownloadListener mDownloadListener;
    protected DownloadingListener mDownloadingListener;
    protected String authority = "";
    public static final int STATUS_NEW = 1000;
    public static final int STATUS_PENDDING = 1001;
    public static final int STATUS_DOWNLOADING = 1002;
    public static final int STATUS_PAUSING = 1003;
    public static final int STATUS_PAUSED = 1004;
    public static final int STATUS_SUCCESSFUL = 1005;
    public static final int STATUS_CANCELED = 1006;
    public static final int STATUS_ERROR = 1007;
    long beginTime = 0L;
    long pauseTime = 0L;
    long endTime = 0L;
    long detalTime = 0L;
    boolean isCustomFile = false;
    boolean uniquePath = true;
    int connectTimes = 0;
    volatile long loaded = 0L;
    String redirect = "";
    DownloadStatusListener mDownloadStatusListener;
    Throwable mThrowable;
    Lock mutex = null;
    Condition mCondition = null;
    volatile boolean isAWait = false;
    protected DownloadNotifier mDownloadNotifier;
    private volatile int status = 1000;

    protected synchronized void setup() {
        if (this.mutex == null) {
            this.mutex = new ReentrantLock();
            this.mCondition = this.mutex.newCondition();
        }
    }

    void resetConnectTimes() {
        this.connectTimes = 0;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    synchronized void setStatus(final @DownloadTaskStatus int status) {
        this.status = status;
        final DownloadStatusListener downloadStatusListener = this.mDownloadStatusListener;
        final DownloadTask downloadTask = this;
        if (null != downloadStatusListener) {
            GlobalQueue.getMainQueue().postRunnable(new Runnable(){

                @Override
                public void run() {
                    downloadStatusListener.onDownloadStatusChanged(downloadTask.clone(), status);
                }
            });
        }
    }

    void resetTime() {
        this.beginTime = 0L;
        this.pauseTime = 0L;
        this.endTime = 0L;
        this.detalTime = 0L;
    }

    public int getId() {
        return this.mId;
    }

    public Context getContext() {
        return this.mContext;
    }

    protected DownloadTask setContext(Context context) {
        this.mContext = context.getApplicationContext();
        return this;
    }

    protected DownloadTask setEnableIndicator(boolean enableIndicator) {
        if (enableIndicator && this.mFile != null && TextUtils.isEmpty((CharSequence)this.authority)) {
            Runtime.getInstance().logError(TAG, "Custom file path, you must specify authority, otherwise the notification should not be turned on. ");
            this.mEnableIndicator = false;
        } else {
            this.mEnableIndicator = enableIndicator;
        }
        return this;
    }

    public File getFile() {
        return this.mFile;
    }

    public Uri getFileUri() {
        return Uri.fromFile((File)this.mFile);
    }

    String getAuthority() {
        return this.authority;
    }

    DownloadTask setFileSafe(@NonNull File file) {
        this.mFile = file;
        return this;
    }

    protected DownloadTask setFile(@NonNull File file) {
        this.mFile = file;
        this.authority = "";
        this.checkCustomFilePath(file);
        return this;
    }

    private void checkCustomFilePath(File file) {
        if (file == null || file.getAbsolutePath().startsWith(Runtime.getInstance().getDefaultDir(this.getContext()).getAbsolutePath())) {
            this.isCustomFile = false;
        } else if (!TextUtils.isEmpty((CharSequence)this.authority)) {
            this.setEnableIndicator(true);
            this.isCustomFile = true;
        } else {
            this.setEnableIndicator(false);
            this.isCustomFile = true;
        }
    }

    boolean isCustomFile() {
        return this.isCustomFile;
    }

    protected DownloadTask setFile(@NonNull File file, @NonNull String authority) {
        if (!file.exists() && file.isFile()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                Runtime.getInstance().logError(TAG, "create file error .");
                return this;
            }
        }
        this.mFile = file;
        this.authority = authority;
        this.checkCustomFilePath(file);
        return this;
    }

    void updateTime(long beginTime) {
        if (this.beginTime == 0L) {
            this.beginTime = beginTime;
            return;
        }
        if (this.beginTime != beginTime) {
            this.detalTime += Math.abs(beginTime - this.pauseTime);
        }
    }

    public long getUsedTime() {
        if (this.status == 1002) {
            return this.beginTime > 0L ? SystemClock.elapsedRealtime() - this.beginTime - this.detalTime : 0L;
        }
        if (this.status == 1006) {
            return this.endTime - this.beginTime - this.detalTime;
        }
        if (this.status == 1001) {
            return this.pauseTime > 0L ? this.pauseTime - this.beginTime - this.detalTime : 0L;
        }
        if (this.status == 1004 || this.status == 1003) {
            return this.pauseTime - this.beginTime - this.detalTime;
        }
        if (this.status == 1000) {
            return this.pauseTime > 0L ? this.pauseTime - this.beginTime - this.detalTime : 0L;
        }
        if (this.status == 1005 || this.status == 1007) {
            return this.endTime - this.beginTime - this.detalTime;
        }
        return 0L;
    }

    public boolean isPausing() {
        return this.getStatus() == 1003;
    }

    public void pausing() {
        this.setStatus(1003);
        this.pauseTime = SystemClock.elapsedRealtime();
    }

    public boolean isPaused() {
        return this.getStatus() == 1004;
    }

    public boolean isCanceled() {
        return this.getStatus() == 1006;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    protected void pause() {
        this.pauseTime = SystemClock.elapsedRealtime();
        this.connectTimes = 0;
        this.setStatus(1004);
    }

    protected void cancel() {
        this.endTime = SystemClock.elapsedRealtime();
        this.setStatus(1006);
    }

    protected void error() {
        this.endTime = SystemClock.elapsedRealtime();
        this.setStatus(1007);
    }

    protected void successful() {
        this.endTime = SystemClock.elapsedRealtime();
        this.setStatus(1005);
    }

    protected void setCalculateMD5(boolean calculateMD5) {
        this.calculateMD5 = calculateMD5;
    }

    boolean isSuccessful() {
        return this.getStatus() == 1005;
    }

    protected void completed() {
        this.endTime = SystemClock.elapsedRealtime();
    }

    protected void destroy() {
        this.mId = -1;
        this.mUrl = null;
        this.mContext = null;
        this.mFile = null;
        this.mIsParallelDownload = false;
        this.mIsForceDownload = false;
        this.mEnableIndicator = true;
        this.mDownloadIcon = 0x1080081;
        this.mDownloadDoneIcon = 17301634;
        this.mIsParallelDownload = true;
        this.mIsBreakPointDownload = true;
        this.mUserAgent = "";
        this.mContentDisposition = "";
        this.mMimetype = "";
        this.mContentLength = -1L;
        if (this.mHeaders != null) {
            this.mHeaders.clear();
            this.mHeaders = null;
        }
        this.retry = 3;
        this.fileMD5 = "";
        this.targetCompareMD5 = "";
        this.calculateMD5 = false;
    }

    DownloadingListener getDownloadingListener() {
        return this.mDownloadingListener;
    }

    protected DownloadTask setDownloadingListener(DownloadingListener downloadingListener) {
        this.mDownloadingListener = downloadingListener;
        return this;
    }

    public DownloadListener getDownloadListener() {
        return this.mDownloadListener;
    }

    protected DownloadTask setDownloadListener(DownloadListener downloadListener) {
        this.mDownloadListener = downloadListener;
        return this;
    }

    protected DownloadTask setDownloadListenerAdapter(DownloadListenerAdapter downloadListenerAdapter) {
        this.setDownloadListener(downloadListenerAdapter);
        this.setDownloadingListener(downloadListenerAdapter);
        this.setDownloadStatusListener(downloadListenerAdapter);
        return this;
    }

    void setTotalsLength(long totalsLength) {
        this.mTotalsLength = totalsLength;
    }

    public long getTotalsLength() {
        return this.mTotalsLength;
    }

    public long getLoaded() {
        return this.loaded;
    }

    void setLoaded(long loaded) {
        this.loaded = loaded;
    }

    protected DownloadTask setBreakPointDownload(boolean breakPointDownload) {
        this.mIsBreakPointDownload = breakPointDownload;
        return this;
    }

    protected DownloadTask setForceDownload(boolean force) {
        this.mIsForceDownload = force;
        return this;
    }

    protected DownloadTask setIcon(@DrawableRes int icon) {
        this.mDownloadIcon = icon;
        return this;
    }

    protected DownloadTask setParallelDownload(boolean parallelDownload) {
        this.mIsParallelDownload = parallelDownload;
        return this;
    }

    protected DownloadTask addHeader(String key, String value) {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap();
        }
        this.mHeaders.put(key, value);
        return this;
    }

    protected DownloadTask autoOpenIgnoreMD5() {
        this.mAutoOpen = true;
        if (this.mFile != null && TextUtils.isEmpty((CharSequence)this.authority)) {
            Runtime.getInstance().logError(TAG, "Custom file path, you must specify authority, otherwise the auto open should be closed. ");
            this.mAutoOpen = false;
        }
        return this;
    }

    protected DownloadTask autoOpenWithMD5(String md5) {
        if (TextUtils.isEmpty((CharSequence)md5)) {
            return this;
        }
        this.mAutoOpen = true;
        if (this.mFile != null && TextUtils.isEmpty((CharSequence)this.authority)) {
            Runtime.getInstance().logError(TAG, "Custom file path, you must specify authority, otherwise the auto open should be closed. ");
            this.mAutoOpen = false;
        }
        this.targetCompareMD5 = md5;
        this.calculateMD5 = true;
        return this;
    }

    protected DownloadTask closeAutoOpen() {
        this.mAutoOpen = false;
        return this;
    }

    protected DownloadTask setDownloadTimeOut(long downloadTimeOut) {
        this.downloadTimeOut = downloadTimeOut;
        return this;
    }

    protected DownloadTask setConnectTimeOut(long connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
        return this;
    }

    protected DownloadTask setBlockMaxTime(long blockMaxTime) {
        this.blockMaxTime = blockMaxTime;
        return this;
    }

    protected DownloadTask setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
        return this;
    }

    DownloadTask setContentLength(long contentLength) {
        this.mContentLength = contentLength;
        return this;
    }

    DownloadTask setMimetype(String mimetype) {
        this.mMimetype = mimetype;
        return this;
    }

    DownloadTask setContentDisposition(String contentDisposition) {
        this.mContentDisposition = contentDisposition;
        return this;
    }

    protected DownloadTask setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    protected DownloadTask setDownloadDoneIcon(@DrawableRes int icon) {
        this.mDownloadDoneIcon = icon;
        return this;
    }

    protected DownloadTask setQuickProgress(boolean quickProgress) {
        this.quickProgress = quickProgress;
        return this;
    }

    protected DownloadTask setTargetCompareMD5(String targetCompareMD5) {
        this.targetCompareMD5 = targetCompareMD5;
        if (!TextUtils.isEmpty((CharSequence)this.targetCompareMD5)) {
            this.calculateMD5 = true;
        }
        return this;
    }

    DownloadTask setFileMD5(String fileMD5) {
        this.fileMD5 = fileMD5;
        return this;
    }

    @Override
    public String getFileMD5() {
        if (TextUtils.isEmpty((CharSequence)this.fileMD5)) {
            this.fileMD5 = Runtime.getInstance().md5(this.mFile);
            if (this.fileMD5 == null) {
                this.fileMD5 = "";
            }
        }
        return super.getFileMD5();
    }

    protected DownloadTask setRetry(int retry) {
        if (retry > 5) {
            retry = 5;
        }
        if (retry < 0) {
            retry = 0;
        }
        this.retry = retry;
        return this;
    }

    protected void createNotifier() {
        if (this.mDownloadNotifier != null) {
            this.mDownloadNotifier.initBuilder(this);
        } else {
            Context mContext = this.getContext().getApplicationContext();
            if (null != mContext && this.isEnableIndicator()) {
                this.mDownloadNotifier = new DownloadNotifier(mContext, this.getId());
                this.mDownloadNotifier.initBuilder(this);
            }
        }
        if (null != this.mDownloadNotifier) {
            this.mDownloadNotifier.onPreDownload();
        }
    }

    String getRedirect() {
        return this.redirect;
    }

    void setRedirect(String redirect) {
        this.redirect = redirect;
    }

    public DownloadTask clone() {
        try {
            DownloadTask downloadTask = new DownloadTask();
            this.copy(downloadTask);
            return downloadTask;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new DownloadTask();
        }
    }

    boolean isCompleted() {
        int status = this.getStatus();
        return status == 1006 || status == 1004 || status == 1005 || status == 1007;
    }

    public boolean isUniquePath() {
        return this.uniquePath;
    }

    protected void setUniquePath(boolean uniquePath) {
        this.uniquePath = uniquePath;
    }

    public DownloadStatusListener getDownloadStatusListener() {
        return this.mDownloadStatusListener;
    }

    void setDownloadStatusListener(DownloadStatusListener downloadStatusListener) {
        this.mDownloadStatusListener = downloadStatusListener;
    }

    Throwable getThrowable() {
        return this.mThrowable;
    }

    void setThrowable(Throwable throwable) {
        this.mThrowable = throwable;
    }

    void await() throws InterruptedException {
        if (this.mutex == null) {
            return;
        }
        this.mutex.lock();
        try {
            while (!this.isCompleted()) {
                this.isAWait = true;
                this.mCondition.await();
            }
        }
        finally {
            this.mutex.unlock();
            this.isAWait = false;
        }
    }

    void anotify() {
        if (this.mutex == null) {
            return;
        }
        this.mutex.lock();
        try {
            this.mCondition.signalAll();
        }
        finally {
            this.mutex.unlock();
        }
    }
}

