/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.text.TextUtils;
import com.download.library.DownloadTask;
import com.download.library.Downloader;
import com.download.library.ExecuteTasksMap;
import com.download.library.ResourceRequest;
import com.download.library.Runtime;
import com.download.library.SyncDownloader;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DownloadImpl {
    private static final DownloadImpl sInstance = new DownloadImpl();
    private ConcurrentHashMap<String, DownloadTask> mTasks = new ConcurrentHashMap();
    private static Context mContext;
    public static final String TAG;

    public static DownloadImpl getInstance() {
        return sInstance;
    }

    public ResourceRequest with(Context context) {
        if (null != context) {
            mContext = context.getApplicationContext();
        }
        return ResourceRequest.with(mContext);
    }

    public ResourceRequest with(String url) {
        if (null == mContext) {
            throw new NullPointerException("Context can't be null . ");
        }
        return ResourceRequest.with(mContext).url(url);
    }

    public ResourceRequest with(Context context, String url) {
        if (null != context) {
            mContext = context.getApplicationContext();
        }
        return ResourceRequest.with(mContext).url(url);
    }

    private void safe(DownloadTask downloadTask) {
        if (null == downloadTask.getContext()) {
            throw new NullPointerException("context can't be null .");
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            throw new NullPointerException("url can't be empty .");
        }
    }

    public boolean enqueue(DownloadTask downloadTask) {
        this.safe(downloadTask);
        return new Downloader().download(downloadTask);
    }

    public File call(DownloadTask downloadTask) {
        this.safe(downloadTask);
        SyncDownloader callable = new SyncDownloader(downloadTask);
        try {
            return (File)callable.call();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File callEx(DownloadTask downloadTask) throws Exception {
        this.safe(downloadTask);
        SyncDownloader callable = new SyncDownloader(downloadTask);
        return (File)callable.call();
    }

    public DownloadTask cancel(String url) {
        return ExecuteTasksMap.getInstance().cancelTask(url);
    }

    public List<DownloadTask> cancelAll() {
        return ExecuteTasksMap.getInstance().cancelTasks();
    }

    public DownloadTask pause(String url) {
        DownloadTask downloadTask = ExecuteTasksMap.getInstance().pauseTask(url);
        if (downloadTask != null) {
            this.mTasks.put(downloadTask.getUrl(), downloadTask);
        }
        return downloadTask;
    }

    public List<DownloadTask> pauseAll() {
        List<DownloadTask> downloadTasks = ExecuteTasksMap.getInstance().pauseTasks();
        if (null != downloadTasks && downloadTasks.size() > 0) {
            for (DownloadTask downloadTask : downloadTasks) {
                this.mTasks.put(downloadTask.getUrl(), downloadTask);
            }
        }
        return downloadTasks;
    }

    public void resumeAll() {
        ConcurrentHashMap<String, DownloadTask> tasks = this.mTasks;
        if (tasks.size() <= 0) {
            return;
        }
        Set<Map.Entry<String, DownloadTask>> sets = tasks.entrySet();
        if (sets != null && sets.size() > 0) {
            for (Map.Entry<String, DownloadTask> entry : sets) {
                DownloadTask downloadTask = entry.getValue();
                if (null == downloadTask || null == downloadTask.getContext() || TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
                    Runtime.getInstance().logError(TAG, "downloadTask death .");
                    continue;
                }
                this.enqueue(downloadTask);
            }
        }
    }

    public boolean resume(String url) {
        DownloadTask downloadTask = this.mTasks.get(url);
        if (null == downloadTask || null == downloadTask.getContext() || TextUtils.isEmpty((CharSequence)downloadTask.getUrl())) {
            Runtime.getInstance().logError(TAG, "downloadTask death .");
            return false;
        }
        this.enqueue(downloadTask);
        return true;
    }

    public boolean exist(String url) {
        return ExecuteTasksMap.getInstance().exist(url);
    }

    static {
        TAG = DownloadImpl.class.getSimpleName();
    }
}

