/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.download.library.DownloadImpl;
import com.download.library.DownloadListener;
import com.download.library.DownloadTask;
import com.download.library.Rumtime;
import java.io.File;

public class ResourceRequest<T extends DownloadTask> {
    private DownloadTask mDownloadTask;

    static ResourceRequest with(Context context) {
        ResourceRequest resourceRequest = new ResourceRequest();
        resourceRequest.mDownloadTask = Rumtime.getInstance().getDefaultDownloadTask();
        resourceRequest.mDownloadTask.setContext(context);
        return resourceRequest;
    }

    public ResourceRequest url(@NonNull String url) {
        this.mDownloadTask.setUrl(url);
        return this;
    }

    public ResourceRequest target(@Nullable File target) {
        this.mDownloadTask.setFile(target);
        return this;
    }

    public ResourceRequest target(@NonNull File target, @NonNull String authority) {
        this.mDownloadTask.setFile(target, authority);
        return this;
    }

    protected ResourceRequest setContentLength(long contentLength) {
        this.mDownloadTask.mContentLength = contentLength;
        return this;
    }

    public ResourceRequest setDownloadTimeOut(long downloadTimeOut) {
        this.mDownloadTask.downloadTimeOut = downloadTimeOut;
        return this;
    }

    public ResourceRequest setConnectTimeOut(int connectTimeOut) {
        this.mDownloadTask.connectTimeOut = connectTimeOut;
        return this;
    }

    public ResourceRequest setOpenBreakPointDownload(boolean openBreakPointDownload) {
        this.mDownloadTask.mIsBreakPointDownload = openBreakPointDownload;
        return this;
    }

    public ResourceRequest setForceDownload(boolean force) {
        this.mDownloadTask.mIsForceDownload = force;
        return this;
    }

    public ResourceRequest setEnableIndicator(boolean enableIndicator) {
        this.mDownloadTask.mEnableIndicator = enableIndicator;
        return this;
    }

    public ResourceRequest setIcon(@DrawableRes int icon) {
        this.mDownloadTask.mIcon = icon;
        return this;
    }

    public ResourceRequest setParallelDownload(boolean parallelDownload) {
        this.mDownloadTask.mIsParallelDownload = parallelDownload;
        return this;
    }

    public ResourceRequest addHeader(String key, String value) {
        if (this.mDownloadTask.mHeaders == null) {
            this.mDownloadTask.mHeaders = new ArrayMap();
        }
        this.mDownloadTask.mHeaders.put(key, value);
        return this;
    }

    public ResourceRequest setAutoOpen(boolean autoOpen) {
        this.mDownloadTask.mAutoOpen = autoOpen;
        return this;
    }

    public File get() {
        return DownloadImpl.getInstance().call(this.mDownloadTask);
    }

    public ResourceRequest setDownloadListener(DownloadListener downloadListener) {
        this.mDownloadTask.setDownloadListener(downloadListener);
        return this;
    }

    public void enqueue() {
        DownloadImpl.getInstance().enqueue(this.mDownloadTask);
    }

    public void enqueue(DownloadListener downloadListener) {
        this.mDownloadTask.setDownloadListener(downloadListener);
        DownloadImpl.getInstance().enqueue(this.mDownloadTask);
    }
}

