/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.wrappers;

import org.bukkit.ChatColor;
import org.bukkit.scoreboard.DisplaySlot;

public class ScoreboardSlot {
    private final DisplaySlot displaySlot;
    private final ChatColor teamColor;

    public ScoreboardSlot(int i) {
        switch (i) {
            case 0: {
                this.displaySlot = DisplaySlot.PLAYER_LIST;
                break;
            }
            case 1: {
                this.displaySlot = DisplaySlot.SIDEBAR;
                break;
            }
            case 2: {
                this.displaySlot = DisplaySlot.BELOW_NAME;
                break;
            }
            default: {
                this.displaySlot = DisplaySlot.SIDEBAR;
            }
        }
        switch (i) {
            case 3: {
                this.teamColor = ChatColor.BLACK;
                break;
            }
            case 4: {
                this.teamColor = ChatColor.DARK_BLUE;
                break;
            }
            case 5: {
                this.teamColor = ChatColor.DARK_GREEN;
                break;
            }
            case 6: {
                this.teamColor = ChatColor.DARK_AQUA;
                break;
            }
            case 7: {
                this.teamColor = ChatColor.DARK_RED;
                break;
            }
            case 8: {
                this.teamColor = ChatColor.DARK_PURPLE;
                break;
            }
            case 9: {
                this.teamColor = ChatColor.GOLD;
                break;
            }
            case 10: {
                this.teamColor = ChatColor.GRAY;
                break;
            }
            case 11: {
                this.teamColor = ChatColor.DARK_GRAY;
                break;
            }
            case 12: {
                this.teamColor = ChatColor.BLUE;
                break;
            }
            case 13: {
                this.teamColor = ChatColor.GREEN;
                break;
            }
            case 14: {
                this.teamColor = ChatColor.AQUA;
                break;
            }
            case 15: {
                this.teamColor = ChatColor.RED;
                break;
            }
            case 16: {
                this.teamColor = ChatColor.LIGHT_PURPLE;
                break;
            }
            case 17: {
                this.teamColor = ChatColor.YELLOW;
                break;
            }
            case 18: {
                this.teamColor = ChatColor.WHITE;
                break;
            }
            default: {
                this.teamColor = null;
            }
        }
    }

    public static ScoreboardSlot of(DisplaySlot slot) {
        switch (slot) {
            case PLAYER_LIST: {
                return new ScoreboardSlot(0);
            }
            case SIDEBAR: {
                return new ScoreboardSlot(1);
            }
            case BELOW_NAME: {
                return new ScoreboardSlot(2);
            }
        }
        return new ScoreboardSlot(1);
    }

    public static ScoreboardSlot ofTeamColor(ChatColor color) {
        switch (color) {
            case BLACK: {
                return new ScoreboardSlot(3);
            }
            case DARK_BLUE: {
                return new ScoreboardSlot(4);
            }
            case DARK_GREEN: {
                return new ScoreboardSlot(5);
            }
            case DARK_AQUA: {
                return new ScoreboardSlot(6);
            }
            case DARK_RED: {
                return new ScoreboardSlot(7);
            }
            case DARK_PURPLE: {
                return new ScoreboardSlot(8);
            }
            case GOLD: {
                return new ScoreboardSlot(9);
            }
            case GRAY: {
                return new ScoreboardSlot(10);
            }
            case DARK_GRAY: {
                return new ScoreboardSlot(11);
            }
            case BLUE: {
                return new ScoreboardSlot(12);
            }
            case GREEN: {
                return new ScoreboardSlot(13);
            }
            case AQUA: {
                return new ScoreboardSlot(14);
            }
            case RED: {
                return new ScoreboardSlot(15);
            }
            case LIGHT_PURPLE: {
                return new ScoreboardSlot(16);
            }
            case YELLOW: {
                return new ScoreboardSlot(17);
            }
            case WHITE: {
                return new ScoreboardSlot(18);
            }
        }
        return new ScoreboardSlot(1);
    }

    public DisplaySlot getDisplaySlot() {
        return this.displaySlot;
    }

    public ChatColor getTeamColor() {
        return this.teamColor;
    }

    public boolean hasTeamColor() {
        return this.teamColor != null;
    }

    public String toString() {
        if (this.teamColor != null) {
            return "sidebar.team." + this.teamColor.name().toLowerCase();
        }
        switch (this.displaySlot) {
            case PLAYER_LIST: {
                return "list";
            }
            case SIDEBAR: {
                return "sidebar";
            }
            case BELOW_NAME: {
                return "belowName";
            }
        }
        return "sidebar";
    }
}

