/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPIConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;

class Config {
    private final boolean verboseOutput;
    private final boolean createDispatcherFile;
    private final Map<Plugin, String[]> pluginsToConvert;
    private final List<String> skipSenderProxy;
    private final List<String> commandsToConvert;

    public Config(FileConfiguration fileConfig) {
        this.verboseOutput = fileConfig.getBoolean("verbose-outputs");
        this.createDispatcherFile = fileConfig.getBoolean("create-dispatcher-json");
        this.pluginsToConvert = new HashMap<Plugin, String[]>();
        this.skipSenderProxy = new ArrayList<String>();
        this.commandsToConvert = new ArrayList<String>();
        for (Map map : fileConfig.getMapList("plugins-to-convert")) {
            String[] pluginCommands;
            if (map.values() == null || map.values().size() == 1 && map.values().iterator().next() == null) {
                pluginCommands = new String[]{};
            } else {
                List commands = (List)map.values().stream().findFirst().get();
                pluginCommands = commands.toArray(new String[0]);
            }
            String pluginName = (String)map.keySet().stream().findFirst().get();
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin != null) {
                this.pluginsToConvert.put(plugin, pluginCommands);
                continue;
            }
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        for (String pluginName : fileConfig.getStringList("skip-sender-proxy")) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin != null) {
                this.skipSenderProxy.add(pluginName);
                continue;
            }
            new InvalidPluginException("Could not find a plugin " + pluginName + "! Has it been loaded properly?").printStackTrace();
        }
        for (String commandName : fileConfig.getStringList("other-commands-to-convert")) {
            this.commandsToConvert.add(commandName);
        }
    }

    public Config(boolean verbose) {
        this.verboseOutput = verbose;
        this.createDispatcherFile = false;
        this.pluginsToConvert = new HashMap<Plugin, String[]>();
        this.skipSenderProxy = new ArrayList<String>();
        this.commandsToConvert = new ArrayList<String>();
    }

    public Config(CommandAPIConfig config) {
        this.verboseOutput = config.verboseOutput;
        this.createDispatcherFile = false;
        this.pluginsToConvert = new HashMap<Plugin, String[]>();
        this.skipSenderProxy = new ArrayList<String>();
        this.commandsToConvert = new ArrayList<String>();
    }

    public boolean hasVerboseOutput() {
        return this.verboseOutput;
    }

    public boolean willCreateDispatcherFile() {
        return this.createDispatcherFile;
    }

    public Set<Map.Entry<Plugin, String[]>> getPluginsToConvert() {
        return this.pluginsToConvert.entrySet();
    }

    public boolean shouldSkipSenderProxy(Plugin plugin) {
        return this.skipSenderProxy.contains(plugin.getName());
    }

    public boolean shouldSkipSenderProxy(String commandName) {
        return this.skipSenderProxy.contains(commandName);
    }

    public List<String> getCommandsToConvert() {
        return this.commandsToConvert;
    }
}

