/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.tr7zw.changeme.nbtapi.NBTContainer;
import dev.jorel.commandapi.CartesianProduct;
import dev.jorel.commandapi.ClassCache;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIVersionHandler;
import dev.jorel.commandapi.CommandPermission;
import dev.jorel.commandapi.CustomCommandExecutor;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.CustomArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.ICustomProvidedArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.Location2DArgument;
import dev.jorel.commandapi.arguments.LocationArgument;
import dev.jorel.commandapi.arguments.LocationType;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.ScoreHolderArgument;
import dev.jorel.commandapi.nms.NMS;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;

public class CommandAPIHandler<CommandListenerWrapper> {
    private static CommandAPIHandler<?> instance;
    final Map<ClassCache, Field> FIELDS = new HashMap<ClassCache, Field>();
    final TreeMap<String, CommandPermission> PERMISSIONS_TO_FIX = new TreeMap();
    final NMS<CommandListenerWrapper> NMS;
    final CommandDispatcher<CommandListenerWrapper> DISPATCHER;
    final Map<String, List<String>> registeredCommands;

    public static CommandAPIHandler<?> getInstance() {
        if (instance == null) {
            instance = new CommandAPIHandler();
        }
        return instance;
    }

    private CommandAPIHandler() {
        String bukkit = Bukkit.getServer().toString();
        this.NMS = CommandAPIVersionHandler.getNMS(bukkit.substring(bukkit.indexOf("minecraftVersion") + 17, bukkit.length() - 1));
        this.DISPATCHER = this.NMS.getBrigadierDispatcher();
        this.registeredCommands = new HashMap<String, List<String>>();
    }

    void checkDependencies() {
        block7: {
            try {
                Class<CommandDispatcher> clazz = CommandDispatcher.class;
            }
            catch (NoClassDefFoundError e) {
                new ClassNotFoundException("Cannot hook into Brigadier (Are you running Minecraft 1.13 or above?)").printStackTrace();
            }
            if (CommandAPI.getConfiguration().hasVerboseOutput()) {
                String compatibleVersions = Arrays.toString(this.NMS.compatibleVersions());
                compatibleVersions = compatibleVersions.substring(1, compatibleVersions.length() - 1);
                CommandAPI.getLog().info("Hooked into NMS " + this.NMS.getClass().getName() + " (compatible with " + compatibleVersions + ")");
            }
            try {
                Class<NBTContainer> container = NBTContainer.class;
                CommandAPI.getLog().info("Hooked into the NBTAPI successfully.");
            }
            catch (NoClassDefFoundError e) {
                if (!CommandAPI.getConfiguration().hasVerboseOutput()) break block7;
                CommandAPI.getLog().warning("Couldn't hook into the NBTAPI for NBT support. Download it from https://www.spigotmc.org/resources/nbt-api.7939/");
            }
        }
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            CommandAPI.getLog().info("Hooked into Spigot successfully for Chat/ChatComponents");
        }
        catch (ClassNotFoundException e) {
            CommandAPI.getLog().warning("Couldn't hook into Spigot for Chat/ChatComponents");
        }
    }

    public NMS<CommandListenerWrapper> getNMS() {
        return this.NMS;
    }

    void unregister(String commandName, boolean force) {
        try {
            if (CommandAPI.getConfiguration().hasVerboseOutput()) {
                CommandAPI.getLog().info("Unregistering command /" + commandName);
            }
            Field children = this.getField(CommandNode.class, "children");
            Map commandNodeChildren = (Map)children.get(this.DISPATCHER.getRoot());
            if (force) {
                ArrayList keysToRemove = new ArrayList();
                commandNodeChildren.keySet().stream().filter(s -> s.contains(":")).filter(s -> s.split(":")[1].equalsIgnoreCase(commandName)).forEach(keysToRemove::add);
                keysToRemove.forEach(commandNodeChildren::remove);
            }
            commandNodeChildren.remove(commandName);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
    }

    Command<CommandListenerWrapper> generateCommand(List<Argument> args, CustomCommandExecutor executor, boolean converted) throws CommandSyntaxException {
        return cmdCtx -> {
            CommandSender sender = this.NMS.getSenderForCommand(cmdCtx, executor.isForceNative());
            if (converted) {
                Object[] argObjs = this.argsToObjectArr(cmdCtx, args);
                int resultValue = 0;
                String[] argsAndCmd = cmdCtx.getRange().get(cmdCtx.getInput()).split(" ");
                Object[] result = new String[argsAndCmd.length - 1];
                System.arraycopy(argsAndCmd, 1, result, 0, argsAndCmd.length - 1);
                List[] entityNamesForArgs = new List[args.size()];
                for (int i = 0; i < args.size(); ++i) {
                    if (args.get(i) instanceof EntitySelectorArgument) {
                        EntitySelectorArgument entitySelectorArg = (EntitySelectorArgument)args.get(i);
                        switch (entitySelectorArg.getEntitySelector()) {
                            case MANY_ENTITIES: {
                                List entities = (List)argObjs[i];
                                entityNamesForArgs[i] = entities.stream().map(CommandSender::getName).collect(Collectors.toList());
                                break;
                            }
                            case MANY_PLAYERS: {
                                List players = (List)argObjs[i];
                                entityNamesForArgs[i] = players.stream().map(CommandSender::getName).collect(Collectors.toList());
                                break;
                            }
                            case ONE_ENTITY: {
                                Entity entity = (Entity)argObjs[i];
                                entityNamesForArgs[i] = Arrays.asList(entity.getName());
                                break;
                            }
                            case ONE_PLAYER: {
                                Player player = (Player)argObjs[i];
                                entityNamesForArgs[i] = Arrays.asList(player.getName());
                                break;
                            }
                        }
                        continue;
                    }
                    entityNamesForArgs[i] = Arrays.asList(new String[]{null});
                }
                List<List<?>> product = CartesianProduct.product(entityNamesForArgs);
                CartesianProduct.flatten(product);
                Iterator<List<?>> iterator = product.iterator();
                while (iterator.hasNext()) {
                    List<?> obj;
                    List<?> strings = obj = iterator.next();
                    for (int i = 0; i < result.length; ++i) {
                        if (strings.get(i) == null) continue;
                        result[i] = (String)strings.get(i);
                    }
                    resultValue += executor.execute(sender, result);
                }
                return resultValue;
            }
            return executor.execute(sender, this.argsToObjectArr(cmdCtx, args));
        };
    }

    Object[] argsToObjectArr(CommandContext<CommandListenerWrapper> cmdCtx, List<Argument> args) throws CommandSyntaxException {
        ArrayList<Object> argList = new ArrayList<Object>();
        for (Argument argument : args) {
            Object result = this.parseArgument(cmdCtx, argument.getNodeName(), argument);
            if (result == null) continue;
            argList.add(result);
        }
        return argList.toArray();
    }

    Object parseArgument(CommandContext<CommandListenerWrapper> cmdCtx, String key, Argument value) throws CommandSyntaxException {
        if (!value.isListed()) {
            return null;
        }
        switch (value.getArgumentType()) {
            case ANGLE: {
                return Float.valueOf(this.NMS.getAngle(cmdCtx, key));
            }
            case ADVANCEMENT: {
                return this.NMS.getAdvancement(cmdCtx, key);
            }
            case AXIS: {
                return this.NMS.getAxis(cmdCtx, key);
            }
            case BIOME: {
                return this.NMS.getBiome(cmdCtx, key);
            }
            case BLOCK_PREDICATE: {
                return this.NMS.getBlockPredicate(cmdCtx, key);
            }
            case BLOCKSTATE: {
                return this.NMS.getBlockState(cmdCtx, key);
            }
            case ADVENTURE_CHAT: {
                return this.NMS.getAdventureChat(cmdCtx, key);
            }
            case CHAT: {
                return this.NMS.getChat(cmdCtx, key);
            }
            case CHATCOLOR: {
                return this.NMS.getChatColor(cmdCtx, key);
            }
            case ADVENTURE_CHAT_COMPONENT: {
                return this.NMS.getAdventureChatComponent(cmdCtx, key);
            }
            case CHAT_COMPONENT: {
                return this.NMS.getChatComponent(cmdCtx, key);
            }
            case CUSTOM: {
                CustomArgument arg = (CustomArgument)value;
                String customresult = arg.isKeyed() ? this.getNMS().getKeyedAsString(cmdCtx, key) : (String)cmdCtx.getArgument(key, String.class);
                try {
                    return arg.getParser().apply(customresult);
                }
                catch (CustomArgument.CustomArgumentException e) {
                    throw e.toCommandSyntax(customresult, cmdCtx);
                }
                catch (Exception e) {
                    String errorMsg = new CustomArgument.MessageBuilder("Error in executing command ").appendFullInput().append(" - ").appendArgInput().appendHere().toString().replace("%input%", customresult).replace("%finput%", cmdCtx.getInput());
                    throw new SimpleCommandExceptionType(() -> errorMsg).create();
                }
            }
            case ENCHANTMENT: {
                return this.NMS.getEnchantment(cmdCtx, key);
            }
            case ENTITY_SELECTOR: {
                EntitySelectorArgument argument = (EntitySelectorArgument)value;
                return this.NMS.getEntitySelector(cmdCtx, key, argument.getEntitySelector());
            }
            case ENTITY_TYPE: {
                return this.NMS.getEntityType(cmdCtx, key);
            }
            case ENVIRONMENT: {
                return this.NMS.getDimension(cmdCtx, key);
            }
            case FLOAT_RANGE: {
                return this.NMS.getFloatRange(cmdCtx, key);
            }
            case FUNCTION: {
                return this.NMS.getFunction(cmdCtx, key);
            }
            case INT_RANGE: {
                return this.NMS.getIntRange(cmdCtx, key);
            }
            case ITEMSTACK: {
                return this.NMS.getItemStack(cmdCtx, key);
            }
            case ITEMSTACK_PREDICATE: {
                return this.NMS.getItemStackPredicate(cmdCtx, key);
            }
            case LITERAL: {
                return ((LiteralArgument)value).getLiteral();
            }
            case LOCATION: {
                LocationType locationType = ((LocationArgument)value).getLocationType();
                return this.NMS.getLocation(cmdCtx, key, locationType);
            }
            case LOCATION_2D: {
                LocationType locationType2d = ((Location2DArgument)value).getLocationType();
                return this.NMS.getLocation2D(cmdCtx, key, locationType2d);
            }
            case LOOT_TABLE: {
                return this.NMS.getLootTable(cmdCtx, key);
            }
            case MATH_OPERATION: {
                return this.NMS.getMathOperation(cmdCtx, key);
            }
            case NBT_COMPOUND: {
                return this.NMS.getNBTCompound(cmdCtx, key);
            }
            case OBJECTIVE: {
                return this.NMS.getObjective(cmdCtx, key);
            }
            case OBJECTIVE_CRITERIA: {
                return this.NMS.getObjectiveCriteria(cmdCtx, key);
            }
            case PARTICLE: {
                return this.NMS.getParticle(cmdCtx, key);
            }
            case PLAYER: {
                return this.NMS.getPlayer(cmdCtx, key);
            }
            case POTION_EFFECT: {
                return this.NMS.getPotionEffect(cmdCtx, key);
            }
            case RECIPE: {
                return this.NMS.getRecipe(cmdCtx, key);
            }
            case ROTATION: {
                return this.NMS.getRotation(cmdCtx, key);
            }
            case SCORE_HOLDER: {
                ScoreHolderArgument scoreHolderArgument = (ScoreHolderArgument)value;
                return scoreHolderArgument.isSingle() ? this.NMS.getScoreHolderSingle(cmdCtx, key) : this.NMS.getScoreHolderMultiple(cmdCtx, key);
            }
            case SCOREBOARD_SLOT: {
                return this.NMS.getScoreboardSlot(cmdCtx, key);
            }
            case MULTI_LITERAL: {
                break;
            }
            case PRIMITIVE_BOOLEAN: 
            case PRIMITIVE_DOUBLE: 
            case PRIMITIVE_FLOAT: 
            case PRIMITIVE_INTEGER: 
            case PRIMITIVE_LONG: 
            case PRIMITIVE_STRING: 
            case PRIMITIVE_GREEDY_STRING: 
            case PRIMITIVE_TEXT: {
                return cmdCtx.getArgument(key, value.getPrimitiveType());
            }
            case SOUND: {
                return this.NMS.getSound(cmdCtx, key);
            }
            case TEAM: {
                return this.NMS.getTeam(cmdCtx, key);
            }
            case TIME: {
                return this.NMS.getTime(cmdCtx, key);
            }
            case UUID: {
                return this.NMS.getUUID(cmdCtx, key);
            }
        }
        return null;
    }

    Predicate<CommandListenerWrapper> generatePermissions(String commandName, CommandPermission permission, Predicate<CommandSender> requirements) {
        CommandPermission finalPermission;
        if (this.PERMISSIONS_TO_FIX.containsKey(commandName.toLowerCase())) {
            if (!this.PERMISSIONS_TO_FIX.get(commandName.toLowerCase()).equals(permission)) {
                permission = this.PERMISSIONS_TO_FIX.get(commandName.toLowerCase());
            }
        } else {
            this.PERMISSIONS_TO_FIX.put(commandName.toLowerCase(), permission);
        }
        if ((finalPermission = permission).getPermission() != null) {
            try {
                Bukkit.getPluginManager().addPermission(new Permission(finalPermission.getPermission()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return clw -> this.permissionCheck(this.NMS.getCommandSenderForCLW(clw), finalPermission, requirements);
    }

    boolean permissionCheck(CommandSender sender, CommandPermission permission, Predicate<CommandSender> requirements) {
        boolean satisfiesPermissions = sender == null ? true : (permission.equals(CommandPermission.NONE) ? true : (permission.equals(CommandPermission.OP) ? sender.isOp() : sender.hasPermission(permission.getPermission())));
        if (permission.isNegated()) {
            satisfiesPermissions = !satisfiesPermissions;
        }
        return satisfiesPermissions && requirements.test(sender);
    }

    void fixPermissions() {
        SimpleCommandMap map = this.NMS.getSimpleCommandMap();
        if (!this.PERMISSIONS_TO_FIX.isEmpty()) {
            CommandAPI.logInfo("Linking permissions to commands:");
        }
        for (Map.Entry<String, CommandPermission> entry : this.PERMISSIONS_TO_FIX.entrySet()) {
            String permNode;
            String cmdName = entry.getKey();
            CommandPermission perm = entry.getValue();
            CommandAPI.logInfo(perm.toString() + " -> /" + cmdName);
            String string = permNode = perm.equals(CommandPermission.NONE) || perm.isNegated() ? "" : perm.getPermission();
            if (this.NMS.isVanillaCommandWrapper(map.getCommand(cmdName))) {
                map.getCommand(cmdName).setPermission(permNode);
            }
            if (!this.NMS.isVanillaCommandWrapper(map.getCommand("minecraft:" + cmdName))) continue;
            map.getCommand(cmdName).setPermission(permNode);
        }
        CommandAPI.getLog().info("Linked " + this.PERMISSIONS_TO_FIX.size() + " Bukkit permissions to commands");
    }

    void register(String commandName, CommandPermission permissions, String[] aliases, Predicate<CommandSender> requirements, List<Argument> args, CustomCommandExecutor executor, boolean converted) throws Exception {
        LiteralCommandNode resultantNode;
        Predicate<Argument> isMultiLiteral = arg -> arg.getArgumentType() == CommandAPIArgumentType.MULTI_LITERAL;
        if (args.stream().filter(isMultiLiteral).count() > 0L) {
            int index = 0;
            for (Argument argument : args) {
                if (isMultiLiteral.test(argument)) {
                    MultiLiteralArgument superArg = (MultiLiteralArgument)argument;
                    for (int i = 0; i < superArg.getLiterals().length; ++i) {
                        LiteralArgument litArg = (LiteralArgument)new LiteralArgument(superArg.getLiterals()[i]).setListed(superArg.isListed()).withPermission(superArg.getArgumentPermission()).withRequirement(superArg.getRequirements());
                        ArrayList<Argument> newArgs = new ArrayList<Argument>();
                        int j = 0;
                        for (Argument previousEntry : args) {
                            if (j == index) {
                                newArgs.add(litArg);
                            } else {
                                newArgs.add(previousEntry);
                            }
                            ++j;
                        }
                        this.register(commandName, permissions, aliases, requirements, newArgs, executor, converted);
                    }
                    return;
                }
                ++index;
            }
        }
        if (this.registeredCommands.containsKey(commandName)) {
            List<String[]> regArgs = this.registeredCommands.get(commandName).stream().map(s -> s.split(":")).collect(Collectors.toList());
            for (int i = 0; i < args.size() && (regArgs.size() != i || regArgs.size() >= args.size()) && ((String[])regArgs.get(i))[0].equals(args.get(i).getNodeName()); ++i) {
                if (i != args.size() - 1 || ((String[])regArgs.get(i))[1].equals(args.get(i).getClass().getSimpleName())) continue;
                StringBuilder builder = new StringBuilder();
                args.forEach(arg -> builder.append(arg.getNodeName()).append("<").append(arg.getClass().getSimpleName()).append("> "));
                StringBuilder builder2 = new StringBuilder();
                regArgs.forEach(arg -> builder2.append(arg[0]).append("<").append(arg[1]).append("> "));
                CommandAPI.getLog().severe("Failed to register command:");
                CommandAPI.getLog().severe("");
                CommandAPI.getLog().severe("  " + commandName + " " + builder.toString());
                CommandAPI.getLog().severe("");
                CommandAPI.getLog().severe("Because it conflicts with this previously registered command:");
                CommandAPI.getLog().severe("");
                CommandAPI.getLog().severe("  " + commandName + " " + builder2.toString());
                CommandAPI.getLog().severe("");
                return;
            }
        }
        this.registeredCommands.put(commandName, args.stream().map(arg -> arg.getNodeName() + ":" + arg.getClass().getSimpleName()).collect(Collectors.toList()));
        if (CommandAPI.getConfiguration().hasVerboseOutput()) {
            StringBuilder builder = new StringBuilder();
            args.forEach(arg -> builder.append(arg.getNodeName()).append("<").append(arg.getClass().getSimpleName()).append("> "));
            CommandAPI.logInfo("Registering command /" + commandName + " " + builder.toString());
        }
        Command<CommandListenerWrapper> command = this.generateCommand(args, executor, converted);
        if (args.isEmpty()) {
            resultantNode = this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(commandName).requires(this.generatePermissions(commandName, permissions, requirements))).executes(command));
            for (String alias : aliases) {
                CommandAPI.logInfo("Registering alias /" + alias + " -> " + resultantNode.getName());
                this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(alias).requires(this.generatePermissions(alias, permissions, requirements))).executes(command));
            }
        } else {
            ArgumentBuilder inner;
            Argument innerArg = args.get(args.size() - 1);
            if (innerArg instanceof LiteralArgument) {
                String str = ((LiteralArgument)innerArg).getLiteral();
                inner = this.getLiteralArgumentBuilderArgument(str, innerArg.getArgumentPermission(), innerArg.getRequirements()).executes(command);
            } else {
                inner = innerArg instanceof ICustomProvidedArgument && !innerArg.getOverriddenSuggestions().isPresent() ? this.getRequiredArgumentBuilderWithProvider(innerArg, this.NMS.getSuggestionProvider(((ICustomProvidedArgument)((Object)innerArg)).getSuggestionProvider())).executes(command) : this.getRequiredArgumentBuilderDynamic(args, innerArg).executes(command);
            }
            ArgumentBuilder outer = inner;
            for (int i = args.size() - 2; i >= 0; --i) {
                Argument outerArg = args.get(i);
                if (outerArg instanceof LiteralArgument) {
                    String str = ((LiteralArgument)outerArg).getLiteral();
                    outer = this.getLiteralArgumentBuilderArgument(str, outerArg.getArgumentPermission(), outerArg.getRequirements()).then(outer);
                    continue;
                }
                outer = outerArg instanceof ICustomProvidedArgument && !outerArg.getOverriddenSuggestions().isPresent() ? this.getRequiredArgumentBuilderWithProvider(outerArg, this.NMS.getSuggestionProvider(((ICustomProvidedArgument)((Object)outerArg)).getSuggestionProvider())).then(outer) : this.getRequiredArgumentBuilderDynamic(args, outerArg).then(outer);
            }
            resultantNode = this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(commandName).requires(this.generatePermissions(commandName, permissions, requirements))).then(outer));
            for (String alias : aliases) {
                if (CommandAPI.getConfiguration().hasVerboseOutput()) {
                    CommandAPI.logInfo("Registering alias /" + alias + " -> " + resultantNode.getName());
                }
                this.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.getLiteralArgumentBuilder(alias).requires(this.generatePermissions(alias, permissions, requirements))).then(outer));
            }
        }
        if (CommandAPI.getConfiguration().willCreateDispatcherFile()) {
            File file = CommandAPI.getDispatcherFile();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace(System.out);
            }
            this.NMS.createDispatcherFile(file, this.DISPATCHER);
        }
    }

    CompletableFuture<Suggestions> getSuggestionsBuilder(SuggestionsBuilder builder, IStringTooltip[] array) {
        String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (int i = 0; i < array.length; ++i) {
            IStringTooltip str = array[i];
            if (!str.getSuggestion().toLowerCase(Locale.ROOT).startsWith(remaining)) continue;
            LiteralMessage tooltipMsg = null;
            if (str.getTooltip() != null) {
                tooltipMsg = new LiteralMessage(str.getTooltip());
            }
            builder.suggest(str.getSuggestion(), tooltipMsg);
        }
        return builder.buildFuture();
    }

    LiteralArgumentBuilder<CommandListenerWrapper> getLiteralArgumentBuilder(String commandName) {
        return LiteralArgumentBuilder.literal((String)commandName);
    }

    LiteralArgumentBuilder<CommandListenerWrapper> getLiteralArgumentBuilderArgument(String commandName, CommandPermission permission, Predicate<CommandSender> requirements) {
        LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)commandName);
        return (LiteralArgumentBuilder)builder.requires(clw -> this.permissionCheck(this.NMS.getCommandSenderForCLW(clw), permission, requirements));
    }

    <T> RequiredArgumentBuilder<CommandListenerWrapper, T> getRequiredArgumentBuilderDynamic(List<Argument> args, Argument argument) {
        if (!argument.getOverriddenSuggestions().isPresent()) {
            RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument((String)argument.getNodeName(), argument.getRawType());
            return (RequiredArgumentBuilder)builder.requires(clw -> this.permissionCheck(this.NMS.getCommandSenderForCLW(clw), argument.getArgumentPermission(), argument.getRequirements()));
        }
        return this.getRequiredArgumentBuilderWithProvider(argument, this.toSuggestions(argument.getNodeName(), args));
    }

    <T> RequiredArgumentBuilder<CommandListenerWrapper, T> getRequiredArgumentBuilderWithProvider(Argument argument, SuggestionProvider<CommandListenerWrapper> provider) {
        RequiredArgumentBuilder builder = RequiredArgumentBuilder.argument((String)argument.getNodeName(), argument.getRawType());
        return ((RequiredArgumentBuilder)builder.requires(clw -> this.permissionCheck(this.NMS.getCommandSenderForCLW(clw), argument.getArgumentPermission(), argument.getRequirements()))).suggests(provider);
    }

    static Argument getArgument(List<Argument> args, String nodeName) {
        return args.stream().filter(arg -> arg.getNodeName().equals(nodeName)).findFirst().get();
    }

    SuggestionProvider<CommandListenerWrapper> toSuggestions(String nodeName, List<Argument> args) {
        return (context, builder) -> {
            Argument arg;
            ArrayList<Object> previousArguments = new ArrayList<Object>();
            Iterator iterator = args.iterator();
            while (iterator.hasNext() && !(arg = (Argument)iterator.next()).getNodeName().equals(nodeName)) {
                Object result;
                try {
                    result = this.parseArgument(context, arg.getNodeName(), arg);
                }
                catch (IllegalArgumentException e) {
                    result = null;
                }
                if (result == null) continue;
                previousArguments.add(result);
            }
            return this.getSuggestionsBuilder(builder, (IStringTooltip[])CommandAPIHandler.getArgument(args, nodeName).getOverriddenSuggestions().orElseGet(() -> (c, m) -> new IStringTooltip[0]).apply(this.NMS.getCommandSenderForCLW(context.getSource()), previousArguments.toArray()));
        };
    }

    public Field getField(Class<?> clazz, String name) {
        ClassCache key = new ClassCache(clazz, name);
        if (this.FIELDS.containsKey(key)) {
            return this.FIELDS.get(key);
        }
        Field result = null;
        try {
            result = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        result.setAccessible(true);
        this.FIELDS.put(key, result);
        return result;
    }
}

