/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.string;

import com.github.jonathanxd.iutils.exceptions.JwIUtilsRuntimeException;
import com.github.jonathanxd.iutils.string.CharSequenceProcessor;

public class StringUtils {
    private String string;

    public StringUtils(String string) {
        this.string = string;
    }

    public StringUtils capitalizeWords() {
        StringBuilder sb = new StringBuilder();
        for (String current : this.string.split(" ")) {
            if (current.trim().isEmpty()) {
                sb.append(current).append(" ");
                continue;
            }
            StringBuilder capitalize = new StringBuilder(current);
            for (int x = 0; x < current.length(); ++x) {
                char c = x == 0 ? Character.toUpperCase(current.charAt(x)) : Character.toLowerCase(current.charAt(x));
                capitalize.setCharAt(x, c);
            }
            sb.append((CharSequence)capitalize).append(" ");
        }
        this.string = sb.toString().endsWith(" ") ? sb.toString().substring(0, sb.length() - 1) : sb.toString();
        return this;
    }

    public StringUtils firstWordUnderlineRemove() {
        StringBuilder sb = new StringBuilder(this.string);
        CharSequenceProcessor processor = CharSequenceProcessor.createCharSequenceProcessor(this.string);
        boolean underline = false;
        while (processor.hasNext()) {
            Character character = processor.next();
            if (character.equals(Character.valueOf('_')) && !underline) {
                underline = true;
                sb.setCharAt(processor.getCurrent(), ' ');
                continue;
            }
            underline = false;
        }
        this.string = sb.toString();
        return this;
    }

    public String toString() {
        return this.string;
    }

    public String getString() {
        return this.toString();
    }

    public static String sCapitalizeWords(String string) {
        return new StringUtils(string).capitalizeWords().getString();
    }

    public static String sFirstWordUnderlineRemover(String s) {
        return new StringUtils(s).capitalizeWords().getString();
    }

    public static String reverseSubstring(String input, int length) {
        if (input.length() - length < 0) {
            throw new JwIUtilsRuntimeException(StringUtils.class, "Invalid length " + length + " for input string [length=" + input.length() + "]");
        }
        return input.substring(input.length() - length);
    }
}

