/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.string;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CharSequenceProcessor
implements Iterator<Character>,
Comparable<CharSequence> {
    private final CharSequence charSequence;
    private Character currentChar;
    private int current = -1;

    CharSequenceProcessor(CharSequence charSequence) {
        this.charSequence = charSequence;
    }

    CharSequenceProcessor() {
        this.charSequence = "";
    }

    @Override
    public synchronized boolean hasNext() {
        return this.current + 1 < this.charSequence.length();
    }

    @Override
    public synchronized Character next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentChar = Character.valueOf(this.charSequence.charAt(++this.current));
        return this.currentChar;
    }

    public Character getCurrentChar() {
        return this.currentChar;
    }

    @Override
    public int compareTo(CharSequence charSequence) {
        int len1 = this.charSequence.length();
        int len2 = charSequence.length();
        int lim = Math.min(len1, len2);
        char[] v1 = this.charSequence.toString().toCharArray();
        char[] v2 = charSequence.toString().toCharArray();
        for (int k = 0; k < lim; ++k) {
            char c1 = v1[k];
            char c2 = v2[k];
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public CharSequence getCharSequence() {
        return this.charSequence;
    }

    public int getCurrent() {
        return this.current;
    }

    public String toString() {
        return this.charSequence.toString();
    }

    public static CharSequenceProcessor createCharSequenceProcessor(String string) {
        return new CharSequenceProcessor(string);
    }
}

