/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.service;

import com.github.jonathanxd.iutils.arrays.Arrays;
import com.github.jonathanxd.iutils.map.FastMap;
import com.github.jonathanxd.iutils.map.SimpleNodeOff;
import com.github.jonathanxd.iutils.service.Service;

public class ServiceManager {
    private static FastMap<Class<? extends Service>, Service> services = new FastMap();
    private static final Arrays<Class<? extends Service>> loadWait = new Arrays<Class>(new Class[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean registerService(Service service) {
        if (!services.containsKey(service.getClass())) {
            if (service.getRelationsClass() != null && service.getRelationsClass().length > 0) {
                Arrays<Class<? extends Service>> arrays = loadWait;
                synchronized (arrays) {
                    loadWait.add(service.getClass());
                }
                for (int x = 0; x < service.getRelationsClass().length; ++x) {
                    Class<? extends Service> current = service.getRelationsClass()[x];
                    if (current == null) continue;
                    System.out.println("--> Checking service: " + current.getName());
                    if (ServiceManager.getService(current) == null) {
                        if (!ServiceManager.isWaitingForLoad(current)) {
                            Service s = service.makeRelation(current);
                            if (s != null) {
                                System.out.println("---> Service not found, loading...");
                                System.out.println("----> Registering needed service: " + s.getName() + " for service: " + service.getName());
                                ServiceManager.registerService(s);
                                System.out.println("----< Registered needed service: " + s.getName() + " for service: " + service.getName());
                                continue;
                            }
                            throw new RuntimeException(new Exception("Cannot load service from class: " + current.getName()));
                        }
                        System.out.println("---< Load task for: " + current.getName() + " already running.");
                        continue;
                    }
                    System.out.println("--< Service found, continue!");
                }
                Arrays<Class<? extends Service>> arrays2 = loadWait;
                synchronized (arrays2) {
                    loadWait.remove(service.getClass());
                }
            }
            System.out.println();
            services.put(service.getClass(), service);
            return true;
        }
        return false;
    }

    public static boolean isWaitingForLoad(Class<? extends Service> wait) {
        return loadWait.contains(wait);
    }

    public static <T extends Service> Service getService(Class<T> serviceClass) {
        if (services.containsGenKey(serviceClass)) {
            return services.get(serviceClass);
        }
        return null;
    }

    public static <T extends Service> Service waitService(Class<T> serviceClass, int max) {
        int x = 0;
        while (ServiceManager.getService(serviceClass) == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (x >= max) break;
            ++x;
        }
        return ServiceManager.getService(serviceClass);
    }

    public static <T extends Service> Service waitService(Class<T> serviceClass) {
        return ServiceManager.waitService(serviceClass, 60);
    }

    public static Arrays<Service> listServices() {
        Arrays<Service> xsServices = new Arrays<Service>(new Service[0]);
        for (SimpleNodeOff simpleNodeOff : services.getNodesOff()) {
            xsServices.add((Service)simpleNodeOff.getValue());
        }
        return xsServices;
    }
}

