/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.object;

import com.github.jonathanxd.iutils.extra.BaseContainer;
import java.util.Objects;
import java.util.Optional;

public class TwoValues<E, E2> {
    private final E value1;
    private final E2 value2;

    public TwoValues(E value1, E2 value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    public TwoValues(BaseContainer<E> container1, BaseContainer<E2> container2) {
        this.value1 = container1.orElseThrow(() -> new NullPointerException("Empty container 1!"));
        this.value2 = container2.orElseThrow(() -> new NullPointerException("Empty container 2!"));
    }

    public TwoValues(Optional<E> container1, Optional<E2> container2) {
        this.value1 = container1.orElseThrow(() -> new NullPointerException("Empty optional 1!"));
        this.value2 = container2.orElseThrow(() -> new NullPointerException("Empty optional 2!"));
    }

    public E getValue1() {
        return this.value1;
    }

    public E2 getValue2() {
        return this.value2;
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2);
    }
}

