/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.object;

import com.github.jonathanxd.iutils.annotations.NotNull;
import com.github.jonathanxd.iutils.object.ReferenceBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class Reference<T>
implements Comparable<Reference> {
    private final Class<? extends T> aClass;
    private final Reference[] related;
    private final Object hold;

    Reference(Class<? extends T> aClass, Reference[] related, Object hold) {
        this.hold = hold;
        this.aClass = Objects.requireNonNull(aClass);
        this.related = related != null ? related : new Reference[]{};
    }

    @NotNull
    public static String toString(Reference reference) {
        StringBuilder sb = new StringBuilder();
        String shortName = reference.getAClass().getSimpleName();
        sb.append(shortName);
        if (reference.getRelated().length != 0) {
            sb.append("<");
            StringJoiner sj = new StringJoiner(", ");
            for (Reference loopRef : reference.getRelated()) {
                sj.add(Reference.toString(loopRef));
            }
            String processResult = sj.toString();
            sb.append(processResult);
            sb.append(">");
        }
        return sb.toString();
    }

    public static <T> ReferenceBuilder<T> to() {
        return Reference.referenceTo();
    }

    public static <T> ReferenceBuilder<T> referenceTo() {
        return new ReferenceBuilder();
    }

    public static <T> ReferenceBuilder<T> a(Class<T> aClass) {
        return Reference.referenceTo().a(aClass);
    }

    public static <T> Reference<T> aEnd(Class<T> aClass) {
        return Reference.referenceTo().a(aClass).build();
    }

    public static <T> ReferenceBuilder<T> but(Reference reference) {
        return Reference.referenceTo().a(reference.getAClass()).of(reference.getRelated());
    }

    public ReferenceBuilder<? extends T> but() {
        return Reference.but(this);
    }

    public Class<? extends T> getAClass() {
        return this.aClass;
    }

    public Object get() {
        return this.hold;
    }

    public Reference[] getRelated() {
        return this.related;
    }

    public String toString() {
        return Reference.toString(this);
    }

    public int hashCode() {
        return Objects.hash(this.aClass, Arrays.deepHashCode(this.related));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Reference)) {
            return false;
        }
        Reference other = (Reference)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(@NotNull Reference compareTo) {
        if (this.getAClass() == compareTo.getAClass()) {
            if (Arrays.deepEquals(this.getRelated(), compareTo.getRelated())) {
                return 0;
            }
            return 1;
        }
        return -1;
    }
}

