/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.object;

import com.github.jonathanxd.iutils.arrays.Arrays;
import com.github.jonathanxd.iutils.object.StringHelper;
import com.github.jonathanxd.iutils.reflection.Reflection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.function.Function;

public class ObjectUtils {
    public static Arrays<Byte> getObjectBytes(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        oos.flush();
        oos.close();
        return Arrays.ofG(Arrays.PrimitiveArray.fromPrimitive(baos.toByteArray()));
    }

    public static Arrays<Byte> getObjectBytesSecure(Object object) {
        Arrays<Byte> bytes = new Arrays<Byte>(new Byte[0]);
        try {
            bytes = ObjectUtils.getObjectBytes(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bytes;
    }

    public static <T> T objectFromBytes(Arrays<Byte> bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(Arrays.PrimitiveArray.toPrimitive(bytes.toGenericArray()));
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object object = ois.readObject();
        ois.close();
        return (T)object;
    }

    public static Object objectFromBytesSecure(Arrays<Byte> bytes) {
        Object object = null;
        try {
            object = ObjectUtils.objectFromBytes(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static StringHelper toHelper(Object object) {
        return new StringHelper(object);
    }

    public static StringHelper deepFields(Object object) {
        return ObjectUtils.deepFields(object, false);
    }

    public static StringHelper deepFields(Object object, boolean semiRecursive) {
        StringHelper helper = ObjectUtils.toHelper(object);
        Collection<Field> fields = Reflection.fieldCollection(object, semiRecursive, false, false);
        for (Field field : fields) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                helper.set(field.getName(), field.get(object));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return helper;
    }

    public static boolean isInstanceOfAny(Object source, Class<?> ... instanceOfObjects) {
        for (Class<?> instanceOf : instanceOfObjects) {
            if (!instanceOf.isAssignableFrom(source.getClass())) continue;
            return true;
        }
        return false;
    }

    public static <E> String strip(E[] elements, Function<E, String> elementStringFactory) {
        StringJoiner sj = new StringJoiner("\n");
        sj.add("");
        for (E element : elements) {
            sj.add(elementStringFactory.apply(element));
        }
        return sj.toString();
    }
}

