/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.map;

import com.github.jonathanxd.iutils.arrays.Arrays;
import com.github.jonathanxd.iutils.map.MapContainer;
import com.github.jonathanxd.iutils.map.MapRegistry;
import com.github.jonathanxd.iutils.map.SimpleNodeOff;
import com.github.jonathanxd.iutils.reflection.Reflection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class FastMap<K, V>
extends MapContainer<K, V> {
    private static final long serialVersionUID = -8307678606769422541L;
    protected final Arrays<MapContainer.Node<K, V>> nodes = new Arrays<MapContainer.Node>(new MapContainer.Node[0]);
    protected Arrays<SimpleNodeOff<K, V>> nodeOff = new Arrays<SimpleNodeOff>(new SimpleNodeOff[0]);
    protected boolean wMod = false;

    public FastMap() {
    }

    public FastMap(MapRegistry register) {
        register.init(this);
    }

    @Override
    public synchronized V putInit(Object key, Object value) {
        if (Reflection.isOnClassInit(FastMap.class)) {
            this.update();
            return (V)this.put(key, value);
        }
        throw new RuntimeException("Cannot put objects out of initialization.");
    }

    @Override
    public synchronized V put(K key, V value) {
        int hash = FastMap.hash(key);
        if (this.nodes.length() > 0) {
            MapContainer.Node<K, V> node = this.nodes.getFirst();
            this.wMod = true;
            if (node.hash == hash && node.key.equals(key)) {
                Object oldValue = node.value;
                node.setValue(value);
                return oldValue;
            }
            while (node.next != null) {
                node = node.next;
                if (node.hash != hash || !node.key.equals(key)) continue;
                Object oldValue = node.value;
                node.setValue(value);
                return oldValue;
            }
            node.next = new MapContainer.Node<K, V>(hash, key, value, null);
        } else {
            this.nodes.add(new MapContainer.Node<K, V>(hash, key, value, null));
            this.wMod = true;
        }
        return null;
    }

    @Override
    public synchronized boolean containsGenKey(K key) {
        return this.containsKey(key);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.containsKey(FastMap.hash(key), key);
    }

    public synchronized boolean containsKey(int hash, Object key) {
        if (this.nodes.length() > 0) {
            MapContainer.Node<K, V> node = this.nodes.getFirst();
            if (node.key.equals(key)) {
                return true;
            }
            while (node.next != null) {
                node = node.next;
                if (!node.key.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        int hash = FastMap.hash(key);
        if (this.nodes.length() > 0) {
            MapContainer.Node<K, V> node = this.nodes.getFirst();
            if (node.hash == hash && node.key.equals(key)) {
                return node.value;
            }
            while (node.next != null) {
                node = node.next;
                if (node.hash != hash || !node.key.equals(key)) continue;
                return node.value;
            }
        }
        return null;
    }

    @Override
    public synchronized int size() {
        return this.nodes.length();
    }

    public synchronized Arrays<SimpleNodeOff<K, V>> getNodesOff() {
        if (this.wMod) {
            MapContainer.Node<K, V> node = this.nodes.getFirst();
            this.nodeOff.add(new SimpleNodeOff<K, V>(node.getKey(), node.getValue()));
            while ((node = node.next) != null) {
                this.nodeOff.add(new SimpleNodeOff<K, V>(node.getKey(), node.getValue()));
            }
            this.wMod = false;
        }
        return this.nodeOff;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("Use getNodesOff instead");
    }

    @Override
    protected synchronized MapContainer.Node<K, V> getNode(int hash, K key) {
        MapContainer.Node<K, V> fNode;
        block7: {
            block8: {
                fNode = this.nodes.getFirst();
                if (fNode == null) break block7;
                if (fNode.hash == hash && fNode.key.equals(key)) break block8;
                fNode = this.nodes.getLast();
                if (!fNode.key.equals(key) || fNode.hash != hash) break block7;
            }
            return fNode;
        }
        if (fNode != null) {
            while ((fNode = fNode.next) != null) {
                if (fNode.hash != hash || !fNode.getKey().equals(key)) continue;
                return fNode;
            }
        } else if (fNode == null) {
            return null;
        }
        return null;
    }

    @Override
    protected synchronized V removef(K key) {
        int hash = FastMap.hash(key);
        V val = this.getNode(hash, key).getValue();
        this.removeNode(hash, key, null);
        return val;
    }

    @Override
    public synchronized V remove(Object key) {
        return this.removef(key);
    }

    @Override
    public synchronized void forEach(BiConsumer<? super K, ? super V> action) {
        for (SimpleNodeOff simpleNodeOff : this.getNodesOff()) {
            action.accept(simpleNodeOff.getKey(), simpleNodeOff.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected synchronized boolean removeNode(int hash, K key, V value) {
        MapContainer.Node<K, V> fNode;
        block6: {
            block7: {
                fNode = this.nodes.getFirst();
                if (fNode == null) break block6;
                if (fNode.hash == hash && fNode.key.equals(key) && (value == null || fNode.value.equals(value))) break block7;
                fNode = this.nodes.getLast();
                if (!fNode.key.equals(key) || fNode.hash != hash || value != null && !fNode.value.equals(value)) break block6;
            }
            this.nodes.remove(fNode);
            return false;
        }
        if (fNode == null) {
            if (fNode != null) return false;
            return false;
        }
        while (fNode.next != null) {
            if (fNode.next.hash == hash && fNode.next.key.equals(key) && (value == null || fNode.next.value.equals(value))) {
                fNode.next = null;
                return true;
            }
            fNode = fNode.next;
        }
        return false;
    }

    private void update() {
        this.wMod = true;
    }

    @Override
    public String toString() {
        Iterator i = this.getNodesOff().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            SimpleNodeOff e = (SimpleNodeOff)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

