/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.list;

import com.github.jonathanxd.iutils.containers.list.IndexedListContainer;
import com.github.jonathanxd.iutils.extra.Container;
import com.github.jonathanxd.iutils.iterator.BackableIterator;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Objects;

public class StaticList<T>
implements IndexedListContainer<T>,
Iterable<T> {
    private final int size;
    private final T[] values;
    private final Class<? extends T> clazz;
    private int slotCache = 0;

    StaticList(Class<? extends T> clazz, int size) {
        this.size = size;
        this.clazz = clazz;
        this.values = (Object[])Array.newInstance(clazz, this.size);
    }

    public static <T> StaticList<T> createStaticListOf(Class<? extends T> listType, int listSize) {
        if (listSize <= 0) {
            throw new RuntimeException("Cannot create a static list with 0 or negative size!");
        }
        return new StaticList<T>(Objects.requireNonNull(listType), listSize);
    }

    public T[] getValues() {
        Object[] dest = (Object[])Array.newInstance(this.clazz, this.size);
        System.arraycopy(this.values, 0, dest, 0, this.size);
        return dest;
    }

    public T[] __unsecureGetValues() {
        return this.values;
    }

    @Override
    public boolean add(T element) {
        int caching = this.nextEmptySlot();
        if (caching != -1) {
            this.values[caching] = element;
            this.nextEmptySlot();
            return true;
        }
        return false;
    }

    @Override
    public Container<T> addAndHold(T element) {
        int caching = this.nextEmptySlot();
        if (caching == -1) {
            caching = this.size - 1;
        }
        T oldValue = this.values[caching];
        this.values[caching] = element;
        this.nextEmptySlot();
        return oldValue != null ? Container.of(oldValue) : (Container)Container.empty();
    }

    @Override
    public boolean remove(T element) {
        for (int x = 0; x < this.size; ++x) {
            if (this.values[x] == null || !this.values[x].equals(element)) continue;
            this.values[x] = null;
            this.slotCache = x;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.emptySlots() == this.values.length;
    }

    @Override
    public int emptySlots() {
        int empty = 0;
        for (int x = 0; x < this.size; ++x) {
            if (this.values[x] != null) continue;
            ++empty;
        }
        return empty;
    }

    @Override
    public boolean isFull() {
        return this.nextEmptySlot() == -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(int index, T element) {
        this.checkIndex(index);
        if (this.values[index] == null) {
            this.values[index] = element;
            this.nextEmptySlot();
            return true;
        }
        return false;
    }

    @Override
    public Container<T> addAndHold(int index, T element) {
        this.checkIndex(index);
        T old = this.values[index];
        this.values[index] = element;
        this.nextEmptySlot();
        return old == null ? (Container<T>)Container.empty() : Container.of(old);
    }

    @Override
    public boolean remove(int index) {
        this.checkIndex(index);
        if (this.values[index] == null) {
            return false;
        }
        this.values[index] = null;
        this.slotCache = index;
        return true;
    }

    @Override
    public Container<T> removeAndHold(int index) {
        this.checkIndex(index);
        if (this.values[index] == null) {
            return (Container)Container.empty();
        }
        T old = this.values[index];
        this.values[index] = null;
        this.slotCache = index;
        return Container.of(old);
    }

    @Override
    public boolean hasEmptySlot() {
        return this.nextEmptySlot() != -1;
    }

    @Override
    public int nextEmptySlot() {
        if (this.slotCache > -1 && this.slotCache < this.values.length && this.values[this.slotCache] == null) {
            return this.slotCache;
        }
        for (int x = 0; x < this.values.length; ++x) {
            if (this.values[x] != null) continue;
            this.slotCache = x;
            return x;
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iter();
    }

    public String toString() {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                sb.append(']');
                sb.append(". Data: [Size: " + this.size + ", Empty Slots: " + this.emptySlots() + "]");
                return sb.toString();
            }
            sb.append(',').append(' ');
        }
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Element[" + this.toString() + "]. Suggested index: " + index);
        }
    }

    @Override
    public boolean contains(T element) {
        for (int x = 0; x < this.size; ++x) {
            if (this.values[x] != null && this.values[x].equals(element)) {
                return true;
            }
            if (this.values[x] != null) continue;
            this.nextEmptySlot();
        }
        return false;
    }

    @Override
    public Container<T> get(int index) {
        this.checkIndex(index);
        if (this.values[index] == null) {
            this.updateCache(index);
            return (Container)Container.empty();
        }
        return Container.of(this.values[index]);
    }

    private void updateCache(int index) {
        if (this.values[this.slotCache] != null && this.values[index] == null) {
            this.slotCache = index;
        }
    }

    public int getSlotCache() {
        return this.slotCache;
    }

    private final class Iter
    implements BackableIterator<T> {
        private int index = -1;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < StaticList.this.size;
        }

        @Override
        public T next() {
            return StaticList.this.values[++this.index];
        }

        @Override
        public boolean hasBack() {
            return this.index - 1 > -1;
        }

        @Override
        public T back() {
            return StaticList.this.values[--this.index];
        }

        @Override
        public int getIndex() {
            return this.index;
        }
    }
}

