/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.extra;

import com.github.jonathanxd.iutils.exceptions.ContainerMakeException;
import com.github.jonathanxd.iutils.extra.BaseContainer;
import com.github.jonathanxd.iutils.extra.IMutableContainer;
import com.github.jonathanxd.iutils.reflection.Reflection;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class MutableContainer<T>
implements IMutableContainer<T> {
    private static BaseContainer<?> empty = new MutableContainer();
    private T value;
    private BiFunction<BaseContainer<T>, T, T> applier = null;

    public MutableContainer() {
        this.value = null;
    }

    public MutableContainer(T value) {
        this.value = value;
    }

    @Override
    public void setApplier(BiFunction<BaseContainer<T>, T, T> applier) {
        this.applier = applier;
    }

    @Override
    public void apply(T value) {
        this.value = this.applier.apply(this, (MutableContainer)value);
    }

    public static <T> MutableContainer<T> make(Class<? super T> clazz) throws ContainerMakeException {
        T value;
        try {
            value = Reflection.constructEmpty(clazz);
        }
        catch (Exception e) {
            throw new ContainerMakeException("Non public empty constructors found for class: " + clazz + "!");
        }
        return new MutableContainer<T>(value);
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isPresent() {
        return this.getValue() != null;
    }

    @Override
    public T getOrElse(T another) {
        Objects.requireNonNull(another);
        return this.isPresent() ? this.getValue() : another;
    }

    @Override
    public T getOr(BaseContainer<T> another) {
        return this.isPresent() ? this.getValue() : another.getValue();
    }

    @Override
    public BaseContainer<T> getOrContainer(BaseContainer<T> another) {
        return this.isPresent() ? this : another;
    }

    @Override
    public void ifPresent(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        if (this.isPresent()) {
            consumer.accept(this.getValue());
        }
    }

    @Override
    public BaseContainer<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : null;
    }

    @Override
    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MutableContainer)) {
            return false;
        }
        BaseContainer other = (BaseContainer)obj;
        return Objects.equals(this.value, other.getValue());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return String.format("Container[%s]", this.isPresent() ? this.value.toString() : "null");
    }

    public static <T> MutableContainer<T> of(T value) {
        Objects.requireNonNull(value);
        return new MutableContainer<T>(value);
    }

    public static <T> MutableContainer<T> of(Class<? super T> clazz) {
        Objects.requireNonNull(clazz);
        return MutableContainer.make(clazz);
    }

    public static <T> T empty() {
        return (T)empty;
    }
}

