/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.extra;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface BaseContainer<T>
extends Comparable<BaseContainer<T>> {
    public void setApplier(BiFunction<BaseContainer<T>, T, T> var1);

    public void apply(T var1);

    public T getValue();

    public boolean isPresent();

    public T getOrElse(T var1);

    public T getOr(BaseContainer<T> var1);

    public BaseContainer<T> getOrContainer(BaseContainer<T> var1);

    public void ifPresent(Consumer<? super T> var1);

    public BaseContainer<T> filter(Predicate<? super T> var1);

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> var1) throws X;

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    default public T get() {
        return this.getValue();
    }

    default public Optional<T> toOptional() {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(this.get());
    }

    @Override
    default public int compareTo(BaseContainer<T> o) {
        if (this.getValue() instanceof Comparable) {
            Comparable comparable = (Comparable)this.getValue();
            return comparable.compareTo(o.get());
        }
        return -1;
    }
}

