/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.exceptions;

import com.github.jonathanxd.iutils.arrays.Arrays;
import com.github.jonathanxd.iutils.reflection.Reflection;

public class JwIUtilsRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 3820066586895196852L;

    public JwIUtilsRuntimeException(Class<?> involved, String exceptionMessage) {
        this(involved, exceptionMessage, 0);
    }

    public JwIUtilsRuntimeException(Class<?> involved, String exceptionMessage, Throwable cause) {
        super(exceptionMessage, cause);
        Arrays<StackTraceElement> arr = Arrays.ofG(super.getStackTrace());
        arr.add(new StackTraceElement(involved.getName(), "<? unknown method>", involved.getSimpleName(), 0));
        super.setStackTrace(arr.toGenericArray());
    }

    public JwIUtilsRuntimeException(Class<?> involved, String exceptionMessage, int offset) {
        super(exceptionMessage);
        StackTraceElement ste = Reflection.getCallInformations(involved);
        Arrays<StackTraceElement> arr = Arrays.ofG(super.getStackTrace());
        arr.add(new StackTraceElement(ste.getClassName(), ste.getMethodName(), ste.getFileName(), ste.getLineNumber() + offset));
        super.setStackTrace(arr.toGenericArray());
    }
}

