/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.comparator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class ComparatorMonitor<T>
implements Comparator<T> {
    private final Comparator<T> comparator;
    private final List<Function<Integer, Integer>> functionList = new ArrayList<Function<Integer, Integer>>();

    public ComparatorMonitor(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public void add(Function<Integer, Integer> func) {
        this.functionList.add(func);
    }

    @Override
    public int compare(T o1, T o2) {
        int result = this.comparator.compare(o1, o2);
        for (Function<Integer, Integer> function : this.functionList) {
            result = function.apply(result);
        }
        return result;
    }

    @Override
    public Comparator<T> reversed() {
        return this.comparator.reversed();
    }

    @Override
    public Comparator<T> thenComparing(Comparator<? super T> other) {
        return this.comparator.thenComparing(other);
    }

    @Override
    public <U> Comparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
        return this.comparator.thenComparing(keyExtractor, keyComparator);
    }

    @Override
    public <U extends Comparable<? super U>> Comparator<T> thenComparing(Function<? super T, ? extends U> keyExtractor) {
        return this.comparator.thenComparing(keyExtractor);
    }

    @Override
    public Comparator<T> thenComparingInt(ToIntFunction<? super T> keyExtractor) {
        return this.comparator.thenComparingInt(keyExtractor);
    }

    @Override
    public Comparator<T> thenComparingLong(ToLongFunction<? super T> keyExtractor) {
        return this.comparator.thenComparingLong(keyExtractor);
    }

    @Override
    public Comparator<T> thenComparingDouble(ToDoubleFunction<? super T> keyExtractor) {
        return this.comparator.thenComparingDouble(keyExtractor);
    }
}

