/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.collection;

import com.github.jonathanxd.iutils.collection.ListSafeBackableIterator;
import com.github.jonathanxd.iutils.iterator.BackableIterator;
import com.github.jonathanxd.iutils.iterator.SafeBackableIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Function;

public class ListUtils {
    private static final String DELIMITER = ", ";
    private static final String PREFIX = "[";
    private static final String SUFFIX = "]";

    public static <E> SafeBackableIterator<E> toSafeBackableIterator(List<E> list) {
        return new ListSafeBackableIterator<E>(list);
    }

    public static <E> BackableIterator<E> toBackableIterator(List<E> list) {
        return ListUtils.toSafeBackableIterator(list);
    }

    public static List<Character> from(char[] primitiveArray) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (char primitiveElement : primitiveArray) {
            list.add(Character.valueOf(primitiveElement));
        }
        return list;
    }

    public static <T> String[] markListPosition(List<T> list, int position, Function<T, String> elementStringFactory) {
        StringJoiner sj = new StringJoiner(DELIMITER, PREFIX, SUFFIX);
        int textPos = PREFIX.length() + SUFFIX.length();
        int x = 0;
        int mark = 0;
        for (T element : list) {
            if (x == position) {
                mark = textPos;
            }
            String text = elementStringFactory.apply(element);
            textPos += DELIMITER.length() + text.length();
            sj.add(text);
            ++x;
        }
        String[] result = new String[]{sj.toString(), String.format(String.format("%%%ds", mark), "^")};
        return result;
    }
}

