/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.builders.abstracts;

import com.github.jonathanxd.iutils.interfaces.CapacityImplement;
import com.github.jonathanxd.iutils.sequence.DoubleSequence;
import java.util.Arrays;

public abstract class AbstractDoubleBuilder
implements DoubleSequence,
CapacityImplement {
    Double[] value;
    int count;

    public AbstractDoubleBuilder() {
    }

    public AbstractDoubleBuilder(int capacity) {
        this.value = new Double[capacity];
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public int capacity() {
        return this.value.length;
    }

    @Override
    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > 0) {
            this.ensureCapacityInternal(minimumCapacity);
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("Double index out of range: " + newLength);
        }
        this.ensureCapacityInternal(newLength);
        if (this.count < newLength) {
            Arrays.fill((Object[])this.value, this.count, newLength, Character.valueOf('\u0000'));
        }
        this.count = newLength;
    }

    @Override
    public Double doubleAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Double index out of range: " + index);
        }
        return this.value[index];
    }

    public void getDoubles(int srcBegin, int srcEnd, Double[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new IndexOutOfBoundsException("Double index out of range: " + srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new IndexOutOfBoundsException("Double index out of range: " + srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new IndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setBoolAt(int index, Double b) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Double index out of range: " + index);
        }
        this.value[index] = b;
    }

    public AbstractDoubleBuilder append(Object obj) {
        return this.append(Double.valueOf(String.valueOf(obj)));
    }

    public AbstractDoubleBuilder append(Double[] doub) {
        int len = doub.length;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(doub, 0, this.value, this.count, len - 0);
        this.count += len;
        return this;
    }

    public AbstractDoubleBuilder append(Double doub) {
        this.ensureCapacityInternal(this.count + 1);
        this.value[this.count] = doub;
        ++this.count;
        return this;
    }

    AbstractDoubleBuilder append(AbstractDoubleBuilder asb) {
        if (asb == null) {
            return this;
        }
        int len = asb.length();
        this.ensureCapacityInternal(this.count + len);
        asb.getDoubles(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public Double[] subdouble(int start) {
        return this.subdouble(start, this.count);
    }

    public Double[] subdouble(int start, int end) {
        Double[] b = new Double[end];
        this.getDoubles(start, end, b, 0);
        return b;
    }

    @Override
    public DoubleSequence subSequence(int start, int end) {
        return new AbstractDoubleBuilder(end){}.append(this.subdouble(start, end));
    }
}

