/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.builders.abstracts;

import com.github.jonathanxd.iutils.interfaces.CapacityImplement;
import com.github.jonathanxd.iutils.sequence.ByteSequence;
import java.util.Arrays;

public abstract class AbstractByteBuilder
implements ByteSequence,
CapacityImplement {
    Byte[] value;
    int count;

    public AbstractByteBuilder() {
    }

    public AbstractByteBuilder(int capacity) {
        this.value = new Byte[capacity];
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public int capacity() {
        return this.value.length;
    }

    @Override
    public void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > 0) {
            this.ensureCapacityInternal(minimumCapacity);
        }
    }

    private void ensureCapacityInternal(int minimumCapacity) {
        if (minimumCapacity - this.value.length > 0) {
            this.expandCapacity(minimumCapacity);
        }
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        this.value = Arrays.copyOf(this.value, newCapacity);
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            this.value = Arrays.copyOf(this.value, this.count);
        }
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new IndexOutOfBoundsException("Byte index out of range: " + newLength);
        }
        this.ensureCapacityInternal(newLength);
        if (this.count < newLength) {
            Arrays.fill((Object[])this.value, this.count, newLength, Character.valueOf('\u0000'));
        }
        this.count = newLength;
    }

    @Override
    public Byte byteAt(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Byte index out of range: " + index);
        }
        return this.value[index];
    }

    public void getBytes(int srcBegin, int srcEnd, Byte[] dst, int dstBegin) {
        if (srcBegin < 0) {
            throw new IndexOutOfBoundsException("Byte index out of range: " + srcBegin);
        }
        if (srcEnd < 0 || srcEnd > this.count) {
            throw new IndexOutOfBoundsException("Byte index out of range: " + srcEnd);
        }
        if (srcBegin > srcEnd) {
            throw new IndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, srcBegin, dst, dstBegin, srcEnd - srcBegin);
    }

    public void setBoolAt(int index, Byte b) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Byte index out of range: " + index);
        }
        this.value[index] = b;
    }

    public AbstractByteBuilder append(Object obj) {
        return this.append(Byte.valueOf(String.valueOf(obj)));
    }

    public AbstractByteBuilder append(Byte[] bool) {
        int len = bool.length;
        this.ensureCapacityInternal(this.count + len);
        System.arraycopy(bool, 0, this.value, this.count, len - 0);
        this.count += len;
        return this;
    }

    public AbstractByteBuilder append(Byte b) {
        this.ensureCapacityInternal(this.count + 1);
        this.value[this.count] = b;
        ++this.count;
        return this;
    }

    AbstractByteBuilder append(AbstractByteBuilder asb) {
        if (asb == null) {
            return this;
        }
        int len = asb.length();
        this.ensureCapacityInternal(this.count + len);
        asb.getBytes(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public Byte[] subbyte(int start) {
        return this.subbyte(start, this.count);
    }

    public Byte[] subbyte(int start, int end) {
        Byte[] b = new Byte[end];
        this.getBytes(start, end, b, 0);
        return b;
    }

    @Override
    public ByteSequence subSequence(int start, int end) {
        return new AbstractByteBuilder(end){}.append(this.subbyte(start, end));
    }
}

