/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.arguments;

import com.github.jonathanxd.iutils.arguments.exception.ParseArgumentException;
import com.github.jonathanxd.iutils.arguments.exception.UnsatisfiedArgumentError;
import com.github.jonathanxd.iutils.arrays.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EasyArguments {
    private final HashMap<String, Arrays<String>> arguments = new HashMap();

    private synchronized EasyArguments registerArgument(String id, Arrays<String> argument) {
        this.arguments.put(id, argument);
        return this;
    }

    private synchronized EasyArguments removeArgument(String id) {
        this.arguments.remove(id);
        return this;
    }

    public synchronized boolean argumentExists(String id) {
        return this.arguments.containsKey(id);
    }

    public synchronized Arrays<String> getLastestArgument(String id) {
        return this.arguments.get(id);
    }

    public synchronized Map<String, Arrays<String>> getArgMap() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public synchronized int length() {
        return this.arguments.size();
    }

    public static EasyArguments parseArgArray(String[] args, String[] singleArgNames) throws ParseArgumentException {
        EasyArguments xArgs = new EasyArguments();
        Arrays<String> arrays = Arrays.ofG(args);
        Arrays<String> single = Arrays.ofG(singleArgNames);
        Iterator iter = arrays.iterator();
        while (iter.hasNext()) {
            String opt = (String)iter.next();
            if (!opt.startsWith("-")) continue;
            if (!single.isEmpty() && single.contains(opt)) {
                xArgs.registerArgument(opt.substring(1), single);
                continue;
            }
            if (iter.hasNext()) {
                String key = opt;
                Arrays<String> argSend = new Arrays<String>(new String[0]);
                while (iter.hasNext() && !(opt = (String)iter.next()).startsWith("-")) {
                    argSend.add(opt);
                }
                if (opt.startsWith("-")) {
                    iter.back();
                }
                xArgs.registerArgument(key.substring(1), argSend);
                continue;
            }
            throw new ParseArgumentException("No provided parameters for argument: ");
        }
        return xArgs;
    }

    public synchronized void checkArguments(String[] ids) throws UnsatisfiedArgumentError {
        Arrays<String> unsatisfiedArgList = new Arrays<String>(new String[0]);
        for (String id : ids) {
            if (this.arguments.containsKey(id)) continue;
            unsatisfiedArgList.add(id);
        }
        if (!unsatisfiedArgList.isEmpty()) {
            throw new UnsatisfiedArgumentError("Unsatisfied Argument(s): " + unsatisfiedArgList);
        }
    }
}

