/*
 * Decompiled with CFR 0.152.
 */
package com.github.jonathanxd.iutils.arguments;

import com.github.jonathanxd.iutils.arguments.Argument;
import com.github.jonathanxd.iutils.arguments.exception.ParseArgumentException;
import com.github.jonathanxd.iutils.arguments.exception.UnsatisfiedArgumentError;
import com.github.jonathanxd.iutils.arrays.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Arguments {
    private final HashMap<String, Argument<?>> arguments = new HashMap();

    public synchronized Arguments registerArgument(String id, Argument<?> argument) {
        this.arguments.put(this.getUnregisteredIdKey(id), argument);
        return this;
    }

    public synchronized Arguments removeArgument(String id, int idKey) {
        this.arguments.remove(id + "#" + idKey);
        return this;
    }

    public synchronized Arguments removeAllArgumentsById(String id) {
        for (int x = 0; x < 257; ++x) {
            if (!this.arguments.containsKey(id + "#" + x)) continue;
            this.arguments.remove(id + "#" + x);
        }
        return this;
    }

    public synchronized boolean argumentExistsById(String id) {
        return this.getLastestIdKey(id) != null;
    }

    public synchronized boolean argumentExists(String id, int idKey) {
        return this.arguments.containsKey(id + "#" + idKey);
    }

    public synchronized <T> Argument<T> getLastestArgument(String id) {
        String lastest = this.getLastestIdKey(id);
        if (lastest != null) {
            return this.arguments.get(lastest);
        }
        return null;
    }

    public synchronized <T> Argument<T> getSpecificArgument(String id, int idKey) {
        if (this.arguments.containsKey(id + "#" + idKey)) {
            return this.arguments.get(id + "#" + idKey);
        }
        return null;
    }

    private String getUnregisteredIdKey(String id) {
        for (int x = 0; x < 257; ++x) {
            if (this.arguments.containsKey(id + "#" + x)) continue;
            return id + "#" + x;
        }
        return id;
    }

    private String getLastestIdKey(String id) {
        for (int x = 256; x > -1; --x) {
            if (!this.arguments.containsKey(id + "#" + x)) continue;
            return id + "#" + x;
        }
        return null;
    }

    public synchronized Map<String, Argument<?>> getArgMap() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public synchronized int length() {
        return this.arguments.size();
    }

    public static Arguments parseArgArray(String[] args, String[] singleArgNames) throws ParseArgumentException {
        Arguments xArgs = new Arguments();
        Arrays<String> arrays = Arrays.ofG(args);
        Arrays<String> single = Arrays.ofG(singleArgNames);
        Iterator iter = arrays.iterator();
        while (iter.hasNext()) {
            String opt = (String)iter.next();
            if (!opt.startsWith("-")) continue;
            if (single.contains(opt)) {
                xArgs.registerArgument(opt, Argument.getNullArgument());
                continue;
            }
            if (iter.hasNext()) {
                String key = opt;
                Arrays<String> argSend = new Arrays<String>(new String[0]);
                while (iter.hasNext() && !(opt = (String)iter.next()).startsWith("-")) {
                    argSend.add(opt);
                }
                if (opt.startsWith("-")) {
                    iter.back();
                }
                Argument<Arrays<String>> argv = new Argument<Arrays<String>>(argSend);
                xArgs.registerArgument(key, argv);
                continue;
            }
            throw new ParseArgumentException("No provided parameters for argument: ");
        }
        return xArgs;
    }

    public synchronized void checkArguments(String[] ids) throws UnsatisfiedArgumentError {
        Arrays<String> unsatisfiedArgList = new Arrays<String>(new String[0]);
        for (String id : ids) {
            if (this.argumentExistsById(id)) continue;
            unsatisfiedArgList.add(id);
        }
        if (!unsatisfiedArgList.isEmpty()) {
            throw new UnsatisfiedArgumentError("Unsatisfied Argument(s): " + unsatisfiedArgList);
        }
    }
}

